% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular_input.R
\name{create_states_from_tabular}
\alias{create_states_from_tabular}
\title{Create State Definitions From Tabular Input}
\usage{
create_states_from_tabular(state_info, df_env = globalenv())
}
\arguments{
\item{state_info}{Result for one model of
\code{\link[=parse_multi_spec]{parse_multi_spec()}}.}

\item{df_env}{An environment containing external data.}
}
\value{
A state list.
}
\description{
Transforms tabular input defining states into an
\code{heemod} object.
}
\details{
Columns of state_info besides .model and state include
costs and utilities we want to keep track of, with
appropriate values (these may include parameters). For
any cost or utility that should be discounted, an
additional column with the name ".discount.<cost>" or
".discount.<effect>", for the appropriate cost or effect,
can be included. If no discounting is desired for a
particular cost or effect, the corresponding column can
be omitted.

A discount column can contain only a single value - a
cost or benefit must be discounted by the same amount in
each state. Discounts can be numbers or parameters (which
will then need to be defined like any other).

The input data frame is expected to contain state
information for all the models you will use in an
analysis. For more information see the vignette:
\code{vignette("file-input", package = "heemod")}.
}
\keyword{internal}
