% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_template.R
\name{export_template}
\alias{export_template}
\title{Safely export templates to file.}
\usage{
export_template(template, filename, sep = "", filename.is.string = TRUE)
}
\arguments{
\item{template}{The template string to be written out}

\item{filename}{The path to write the template to, passed to
\code{\link[base]{writeLines}}. Also accepts \code{\link[base]{stdout}}
(and likely other similar functions) with a warning.}

\item{sep}{Separator to use between lines written, passed to
\code{\link[base]{writeLines}}. Defaults to no separator, as templates are
generally already spaced appropriately.}

\item{filename.is.string}{A binary value indicating whether or not the
filename parameter is expected to be a string (that is, a character
vector). Setting the value to FALSE disables the warning when a
non-character argument is passed, but this is unsupported functionality.}
}
\value{
Returns the input template invisibly.
}
\description{
This is a simple wrapper function around \code{\link[utf8]{as_utf8}} and
\code{\link[base]{writeLines}}, letting users write their template strings
to file without having to worry about file encodings. For more details on
why UTF-8 encoding is necessary, check out
\href{https://yihui.org/en/2018/11/biggest-regret-knitr/}{Yihui Xie's} post
on the subject.
}
\details{
Note that this function is effectively the inverse of
\code{\link{import_pattern}} --
\code{export_template(import_pattern("out.txt"), "out.txt")} should
always result in an unchanged file, and exceptions to this rule would be
considered bugs.
}
\examples{
pattern_file <- tempfile("out", tempdir(), ".Rmd")
export_template("my sample pattern", pattern_file)
}
\concept{export functions}
