% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-to-tbl.R
\name{ts_to_tbl}
\alias{ts_to_tbl}
\title{Coerce a time-series object to a tibble}
\usage{
ts_to_tbl(.data)
}
\arguments{
\item{.data}{The time-series object you want transformed into a \code{tibble}}
}
\value{
A tibble
}
\description{
This function takes in a time-series object and returns it in a
\code{tibble} format.
}
\details{
This function makes use of \code{\link[timetk:tk_tbl]{timetk::tk_tbl()}} under the hood to obtain
the initial \code{tibble} object. After the inital object is obtained a new column
called \code{date_col} is constructed from the \code{index} column using \code{lubridate} if
an index column is returned.
}
\examples{

ts_to_tbl(BJsales)
ts_to_tbl(AirPassengers)

}
\seealso{
Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
