% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-model-extraction.R
\name{model_extraction_helper}
\alias{model_extraction_helper}
\title{Model Method Extraction Helper}
\usage{
model_extraction_helper(.fit_object)
}
\arguments{
\item{.fit_object}{A time-series fitted model}
}
\value{
A model description
}
\description{
This takes in a model fit and returns the method of the fit object.
}
\details{
Currently supports forecasting model of one of the following from the
\code{forecast} package:
\itemize{
\item \code{\link[forecast]{Arima}}
\item \code{\link[forecast]{auto.arima}}
\item \code{\link[forecast]{ets}}
\item \code{\link[forecast]{nnetar}}
\item \code{workflow} fitted models.
}
}
\examples{
# NOT RUN
\dontrun{
suppressPackageStartupMessages(library(forecast))

# Create a model
fit_arima  <- auto.arima(AirPassengers)

model_extraction_helper(fit_arima)
}

}
\seealso{
Other Utility: 
\code{\link{calibrate_and_plot}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
