% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-svm-poly-reg.R
\name{ts_wfs_svm_poly}
\alias{ts_wfs_svm_poly}
\title{Auto SVM Poly (Kernlab) Workflowset Function}
\usage{
ts_wfs_svm_poly(
  .model_type = "kernlab",
  .recipe_list,
  .cost = 1,
  .degree = 1,
  .scale_factor = 1,
  .margin = 0.1
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[parsnip:svm_poly]{parsnip::svm_poly()}} under the hood and can take one of the following:
\itemize{
\item "kernlab"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.cost}{A positive number for the cose of predicting a sample within or
on the wrong side of the margin.}

\item{.degree}{A positive number for polynomial degree.}

\item{.scale_factor}{A positive number for the polynomial scaling factor.}

\item{.margin}{A positive number for the epsilon in the SVM insensitive loss
function (regression only.)}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This only uses the option \code{set_engine("kernlab")} and therefore the .model_type
is not needed. The parameter is kept because it is possible in the future that
this could change, and it keeps with the framework of how other functions
are written.

\code{\link[parsnip:svm_poly]{parsnip::svm_poly()}} svm_poly() defines a support vector machine model.
For classification, the model tries to maximize the width of the margin
between classes. For regression, the model optimizes a robust loss function
that is only affected by very large model residuals.

This SVM model uses a nonlinear function, specifically a polynomial function,
to create the decision boundary or regression line.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(tidymodels))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_svm_poly("kernlab", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://parsnip.tidymodels.org/reference/svm_poly.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
