% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_user_item_tbl}
\alias{hai_kmeans_user_item_tbl}
\alias{kmeans_user_item_tbl}
\title{K-Means User Item Tibble}
\usage{
hai_kmeans_user_item_tbl(.data, .row_input, .col_input, .record_input)

kmeans_user_item_tbl(.data, .row_input, .col_input, .record_input)
}
\arguments{
\item{.data}{The data that you want to transform}

\item{.row_input}{The column that is going to be the row (user)}

\item{.col_input}{The column that is going to be the column (item)}

\item{.record_input}{The column that is going to be summed up for the aggregation
and normalization process.}
}
\value{
A aggregated/normalized user item tibble
}
\description{
Takes in a data.frame/tibble and transforms it into an aggregated/normalized
user-item tibble of proportions. The user will need to input the parameters
for the rows/user and the columns/items.
}
\details{
This function should be used before using a k-mean model. This is
commonly referred to as a user-item matrix because "users" tend to be on the
rows and "items" (e.g. orders) on the columns. You must supply a column that
can be summed for the aggregation and normalization process to occur.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
)

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
