% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-hai-hyperbolic.R
\name{hai_hyperbolic_augment}
\alias{hai_hyperbolic_augment}
\title{Augment Function Hyperbolic}
\usage{
hai_hyperbolic_augment(
  .data,
  .value,
  .names = "auto",
  .scale_type = c("sin", "cos", "tan", "sincos")
)
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:nse-defuse]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.names}{The default is "auto"}

\item{.scale_type}{A character of one of the following: "sin","cos","tan", "sincos" All
can be passed by setting the param equal to c("sin","cos","tan","sincos")}
}
\value{
A augmented tibble
}
\description{
Takes a numeric vector(s) or date and will return a tibble of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "tan"
\item "sincos"
\item c("sin","cos","tan", "sincos")
}
}
\details{
Takes a numeric vector or date and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "tan"
\item "sincos"
\item c("sin","cos","tan", "sincos")
}

This function is intended to be used on its own in order to add columns to a
tibble.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 10
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

hai_hyperbolic_augment(data_tbl, b, .scale_type = "sin")
hai_hyperbolic_augment(data_tbl, b, .scale_type = "tan")

}
\seealso{
Other Augment Function: 
\code{\link{hai_fourier_augment}()},
\code{\link{hai_fourier_discrete_augment}()},
\code{\link{hai_polynomial_augment}()},
\code{\link{hai_scale_zero_one_augment}()},
\code{\link{hai_winsorized_move_augment}()},
\code{\link{hai_winsorized_truncate_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
