#' Patient diabetes dataset
#'
#' A dataset containing diabetes status and other health-related variables for
#' 768 females, at least 21 years old, of Pima Indian heritage. As pointed out
#' (see source URL below), the source data had some biologically impossible zero
#' values. We have replaced zero values in every variable except
#' \code{Pregnancies} with NA.
#'
#' @format A tibble data frame with 768 rows and 10 variables:
#' \describe{
#'   \item{patient_id}{unique identifier}
#'   \item{pregnancies}{Number of times pregnant}
#'   \item{plasma_glucose}{Plasma glucose concentration 2 hours in an oral
#'   glucose tolerance test}
#'   \item{diastolic_bp}{Diastolic blood pressure (mm Hg)}
#'   \item{skinfold}{Triceps skin fold thickness (mm)}
#'   \item{insulin}{2-Hour serum insulin (mu U/ml)}
#'   \item{weight_class}{Derived from BMI}
#'   \item{pedigree}{Diabetes pedigree function}
#'   \item{age}{Age (years)}
#'   \item{diabetes}{Y/N diagnosis per WHO criteria}
#' }
#'
#' @source \url{https://archive.ics.uci.edu/ml/datasets/pima+indians+diabetes}
"pima_diabetes"
