% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5D.R
\docType{class}
\name{H5D-class}
\alias{H5D-class}
\alias{H5D}
\title{Class for representing HDF5 datasets}
\value{
Object of class \code{\link{H5D}}.
}
\description{
In HDF5, datasets can be located in a group (see \code{\link{H5Group}}) or at the
root of a file (see \code{\link{H5File}}). They can be created either with a pre-existing R-object
(arrays as well as data.frames are supported, but not lists or other complex objects), or by specifying
an explicit datatype (for available datatypes see \code{h5types$overview} as well as the dimension.
In addition, other features are supported such as transparent compression (for which a chunk-size can be selected).
}
\details{
In order to create a dataset, the \code{create_dataset} methods of either \code{\link{H5Group}} or
\code{\link{H5File}} should be used. Please see the documentation there for how to create them.

The most important parts of a dataset are the 
\describe{
  \item{Space}{The space of the dataset. It describes the dimension of the dataset as well as the maximum dimensions.
               Can be obtained using the \code{get_space} of the \code{\link{H5S}} object.}
  \item{Datatype}{The datatypes that is being used in the dataset. Can be obtained using the \code{get_type} method.
                  See \code{\link{H5T}} to get more information about using datatypes.}
}

In order to read and write datasets, the \code{read} and \code{write} methods are available. In addition, the standard way of using
\code{[} to access arrays is supported as well (see \code{\link{H5S_H5D_subset_assign}} for more help).

Other information/action of possible interest are
\describe{
  \item{Storage size}{The size of the dataset can be extracted using \code{get_storage_size}}
  \item{Size change}{The size of the dataset can be changed using the \code{set_extent} method}
}

Please also note the active methods
\describe{
  \item{dims}{Dimension of the dataset}
  \item{maxdims}{Maximum dimensions of the dataset}
  \item{chunk_dims}{Dimension of the chunks}
  \item{key_info}{Returns the space, type, property-list and dimensions}
}
}
\section{Methods}{

\describe{
\item{\code{new(id = NULL)}}{

Initializes a new dataset-object. Only for internal use. Use the \code{create_dataset} function for \code{\link{H5Group}}
and \code{\link{H5File}} objects

\strong{Parameters}
\describe{
\item{id}{For internal use only}
}}

\item{\code{get_space()}}{

This function implements the HDF5-API function H5Dget_space.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_space_status()}}{

This function implements the HDF5-API function H5Dget_space_status.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_type(native = TRUE)}}{

This function implements the HDF5-API function H5Dget_type.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_create_plist()}}{

This function implements the HDF5-API function H5Dget_create_plist.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_access_plist()}}{

This function implements the HDF5-API function H5Dget_access_plist.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_offset()}}{

This function implements the HDF5-API function H5Dget_offset.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_storage_size()}}{

This function implements the HDF5-API function H5Dget_storage_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{vlen_get_buf_size(type, space)}}{

This function implements the HDF5-API function H5Dvlen_get_buf_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{vlen_reclaim(buffer, type, space,
  dataset_xfer_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Dvlen_reclaim.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{read_low_level(file_space = h5const$H5S_ALL, mem_space = NULL,
  mem_type = NULL, dataset_xfer_pl = h5const$H5P_DEFAULT,
  flags = getOption("hdf5r.h5tor_default"), set_dim = FALSE,
  dim_to_set = NULL, drop = TRUE)}}{

This function is for advanced users. It is recommended to use \code{read} instead or the \code{[} interface.
This function implements the HDF5-API function H5Dread, with minor changes to the API to accommodate R.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.
It reads the data in the dataset as specified by \code{mem_space} and return it as an R-obj

\strong{Parameters}
\describe{
\item{file_space}{An HDF5-space, represented as class \code{\link{H5S}} that determines which part
of the dataset is being read. Can also be given as an id}
\item{mem_space}{The space as it is represented in memory; advanced feature; may be removed in the future.
Can also be given as an id.}
\item{mem_type}{Memory type; extracted from the dataset if null (can be passed in for efficiency reasons
Can also be given as an id.}
\item{dataset_xfer_pl}{Dataset transfer property list. See \code{\link{H5P_DATASET_XFER}}}
\item{flags}{Conversion rules for integer values. See also \code{\link{h5const}}}
\item{set_dim}{If \code{TRUE}, the dimension attribute is set in the return value. How it is set 
is determined by \code{dim_to_set}.}
\item{dim_to_set}{The dimension to set; Has to be numeric and needs to be specified if \code{set_dim} is \code{TRUE}.
If the result is a data.frame, i.e. the data-type is a compound, then the dimension is ignored as the
correct dimension is already set.}
\item{drop}{Logical. Should dimensions of length 1 be dropped (R-default for arrays)}
}}

\item{\code{read(args = NULL, dataset_xfer_pl = h5const$H5P_DEFAULT,
  flags = getOption("hdf5r.h5tor_default"), drop = TRUE,
  envir = parent.frame())}}{

Main interface for reading data from the dataset. It is the function that is used by \code{[}, where
all indices are being passed in the parameter \code{args}.

\strong{Parameters}
\describe{
\item{args}{The indices for each dimension to subset given as a list. This makes this easier to use as a programmatic API.
For interactive use we recommend the use of the \code{[} operator. If set to \code{NULL}, the entire dataset will be read.}
\item{envir}{The environment in which to evaluate \code{args}}
\item{dataset_xfer_pl}{An object of class \code{\link{H5P_DATASET_XFER}}.}
\item{flags}{Some flags governing edge cases of conversion from HDF5 to R. This is related to how integers are being treated and
the issue of R not being able to natively represent 64bit integers and not at all being able to represent unsigned 64bit integers
(even using add-on packages). The constants governing this are part of \code{\link{h5const}}. The relevant ones start with the term
\code{H5TOR} and are documented there. The default set here returns a regular 32bit integer if it doesn't lead to an overflow
and returns a 64bit integer from the \code{bit64} package otherwise. For 64bit unsigned int that are larger than 64bit signed int,
it return a \code{double}. This looses precision, however.}
\item{drop}{Logical. When reading data, should dimensions of size 1 be dropped.}
}

\strong{Return}

The data that was read as an R object


}

\item{\code{write_low_level(robj, file_space = h5const$H5S_ALL,
  mem_space = NULL, mem_type = NULL,
  dataset_xfer_pl = h5const$H5P_DEFAULT,
  flush = getOption("hdf5r.flush_on_write"))}}{

This function is for advanced users. It is recommended to use \code{read} instead or the \code{[<-} interface
as used for arrays.
This function implements the HDF5-API function H5Dwrite, with some changes to accommodate R.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.
It writes that data from the \code{robj} into the dataset.

\strong{Parameters}
\describe{
\item{robj}{The object to write into the dataset}
\item{mem_space}{The space as it is represented in memory; advanced feature; may be removed in the future}
\item{mem_type}{Memory type; extracted from the dataset if null (can be passed in for efficiency reasons}
\item{file_space}{An HDF5-space, represented as class \code{\link{H5S}} that determines which part
of the dataset is being written.}
\item{dataset_xfer_pl}{Dataset transfer property list. See \code{\link{H5P_DATASET_XFER}}}
\item{flush}{Should a flush be done after the write}
}}

\item{\code{write(args, value, dataset_xfer_pl = h5const$H5P_DEFAULT,
  envir = parent.frame())}}{

Main interface for writing data to the dataset. It is the function that is used by \code{[<-}, where
all indices are being passed in the parameter \code{args}.

\strong{Parameters}
\describe{
\item{args}{The indices for each dimension to subset given as a list. This makes this easier to use as a programmatic API.
For interactive use we recommend the use of the \code{[} operator. If set to \code{NULL}, the entire dataset will be read.}
\item{value}{The data to write to the dataset}
\item{envir}{The environment in which to evaluate \code{args}}
\item{dataset_xfer_pl}{An object of class \code{\link{H5P_DATASET_XFER}}.}
}

\strong{Return}

The HDF5 dataset object, returned invisibly


}

\item{\code{set_extent(dims)}}{

This function implements the HDF5-API function H5Dset_extent.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_d.html} for details.}

\item{\code{get_fill_value()}}{

This function implements the HDF5-API function H5Pget_fill_value, automatically
supplying the datatype of the dataset for convenience.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_p.html} for details.}

\item{\code{create_reference(...)}}{

This function implements the HDF5-API function H5Rcreate. The parameters are interpreted as in '['.
The function always create \code{H5R_DATASET_REGION} references
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_r.html} for details.}

\item{\code{print(..., max.attributes = 10)}}{

Prints information for the dataset

\strong{Parameters}
\describe{
\item{...}{ignored}
\item{max.attributes}{Maximum number of attribute names to print}
}}

\item{\code{obj_info(remove_internal_use_only = TRUE)}}{

This function implements the HDF5-API function H5Oget_info.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_o.html} for details.}

\item{\code{get_obj_name()}}{

This function implements the HDF5-API function H5Iget_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_i.html} for details.}

\item{\code{create_attr(attr_name, robj = NULL, dtype = NULL, space = NULL)}}{

This function implements the HDF5-API function H5Acreate2.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open(attr_name)}}{

This function implements the HDF5-API function H5Aopen.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{create_attr_by_name(attr_name, obj_name, robj = NULL,
  dtype = NULL, space = NULL,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Acreate_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_exists_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aexists_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_exists(attr_name)}}{

This function implements the HDF5-API function H5Aexists.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_rename_by_name(old_attr_name, new_attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Arename_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_rename(old_attr_name, new_attr_name)}}{

This function implements the HDF5-API function H5Arename.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete(attr_name)}}{

This function implements the HDF5-API function H5Adelete.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_info_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_info_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_name_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_name_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_get_number()}}{

This function implements the HDF5-API function H5Aget_num_attrs.
Please see the documentation at \url{https://support.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-NumAttrs} for details.}

\item{\code{flush(scope = h5const$H5F_SCOPE_GLOBAL)}}{

This function implements the HDF5-API function H5Fflush.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_f.html} for details.}

\item{\code{get_filename()}}{

This function implements the HDF5-API function H5Fget_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_f.html} for details.}

\item{\code{dims()}}{

Get the dimension of the dataset}

\item{\code{maxdims()}}{

Get the maximal dimension of the dataset}

\item{\code{chunk_dims()}}{

Return the dimension of the chunks. NA if the dataset is not chunked}

\item{\code{key_info()}}{

Returns the key types as a list, consisting of type, space, dataset_create_pl,
type_size_raw, type_size_variable, dims and chunk_dims.
type_size_raw versus variable differs for variable length types, which return \code{Inf}
for type_size_variable and the underlying size for type_size_raw}
}}

\examples{
# First create a file to create datasets in it
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")

# Show the 3 different ways how to create a dataset
file[["directly"]] <- matrix(1:10, ncol=2)
file$create_dataset("from_robj", matrix(1:10, ncol=2))
dset <- file$create_dataset("basic", dtype=h5types$H5T_NATIVE_INT,
             space=H5S$new("simple", dims=c(5, 2), maxdims=c(10,2)), chunk_dims=c(5,2))

# Different ways of reading the dataset
dset$read(args=list(1:5, 1))
dset$read(args=list(1:5, quote(expr=)))
dset$read(args=list(1:5, NULL))
dset[1:5, 1]
dset[1:5, ]
dset[1:5, NULL]

# Writing to the dataset
dset$write(args=list(1:3, 1:2), value=11:16)
dset[4:5, 1:2] <- -(1:4)
dset[,]

# Extract key information
dset$dims
dset$maxdims
dset$chunk_dims
dset$key_info
dset

file$close_all()
file.remove(fname)
}
\author{
Holger Hoefling
}
