% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{H5-attributs}
\alias{H5-attributs}
\alias{h5Attr}
\alias{h5Attributes}
\alias{h5AttrNames}
\alias{h5DeleteAttr}
\alias{h5WriteAttr}
\alias{h5Attr.H5D}
\alias{h5Attr.H5Group}
\alias{h5Attr.H5File}
\alias{h5Attr.character}
\alias{h5AttrNames.H5D}
\alias{h5AttrNames.H5Group}
\alias{h5AttrNames.H5File}
\alias{h5AttrNames.character}
\alias{h5Attributes.H5D}
\alias{h5Attributes.H5Group}
\alias{h5Attributes.H5File}
\alias{h5Attributes.character}
\alias{h5WriteAttr.H5D}
\alias{h5WriteAttr.H5Group}
\alias{h5WriteAttr.H5File}
\alias{h5WriteAttr.character}
\alias{h5DeleteAttr.H5D}
\alias{h5DeleteAttr.H5Group}
\alias{h5DeleteAttr.H5File}
\alias{h5DeleteAttr.character}
\title{Manipulate HDF5 attributes}
\usage{
h5Attr(x, which, ...)

h5Attributes(x, ...)

h5AttrNames(x, ...)

h5DeleteAttr(x, which, ...)

h5WriteAttr(x, which, robj, ...)

\method{h5Attr}{H5D}(x, which, ...)

\method{h5Attr}{H5Group}(x, which, name = NULL, ...)

\method{h5Attr}{H5File}(x, which, name = NULL, ...)

\method{h5Attr}{character}(x, which, name = NULL, ...)

\method{h5AttrNames}{H5D}(x, ...)

\method{h5AttrNames}{H5Group}(x, name = NULL, ...)

\method{h5AttrNames}{H5File}(x, name = NULL, ...)

\method{h5AttrNames}{character}(x, name = NULL, ...)

\method{h5Attributes}{H5D}(x, ...)

\method{h5Attributes}{H5Group}(x, name = NULL, ...)

\method{h5Attributes}{H5File}(x, name = NULL, ...)

\method{h5Attributes}{character}(x, name = NULL, ...)

\method{h5WriteAttr}{H5D}(
  x,
  which,
  robj,
  overwrite = TRUE,
  check.scalar = TRUE,
  stype = c("utf8", "ascii7"),
  ...
)

\method{h5WriteAttr}{H5Group}(
  x,
  which,
  robj,
  name = NULL,
  overwrite = TRUE,
  check.scalar = TRUE,
  stype = c("utf8", "ascii7"),
  ...
)

\method{h5WriteAttr}{H5File}(
  x,
  which,
  robj,
  name = NULL,
  overwrite = TRUE,
  check.scalar = TRUE,
  stype = c("utf8", "ascii7"),
  ...
)

\method{h5WriteAttr}{character}(
  x,
  which,
  robj,
  name = NULL,
  overwrite = TRUE,
  check.scalar = TRUE,
  stype = c("utf8", "ascii7"),
  ...
)

\method{h5DeleteAttr}{H5D}(x, which, ...)

\method{h5DeleteAttr}{H5Group}(x, which, name = NULL, ...)

\method{h5DeleteAttr}{H5File}(x, which, name = NULL, ...)

\method{h5DeleteAttr}{character}(x, which, name = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}}, 
\code{\link[hdf5r]{H5D}} or a path name of HDF5 file.}

\item{which}{Name of the HDF5 attribute}

\item{...}{Arguments passed to other methods.}

\item{robj}{An R object to be written as HDF5 attribute}

\item{name}{Name of an existing HDF5 sub-link. Default is NULL, which will 
use current link.}

\item{overwrite}{Whether or not to overwrite the existing HDF5 attribute.}

\item{check.scalar}{Whether or not to use scalar space when \code{robj} is a
scalar. If \code{FALSE}, the attribute written will be treated as an array.}

\item{stype}{Passed to \code{\link{h5GuessDtype}}}
}
\value{
\code{H5Attr}:
\itemize{
\item If \code{which} exists in link \code{name}, will return an R object 
representing the attribute. If \code{which} doesn't exist or contains empty 
data, will return \code{NULL}.
\item If \code{name} doesn't exist, will raise an error from 
\code{H5File$attr_exists_by_name()}.
}

\code{h5AttrNames} will return a character vector containing all attribute 
names for the given link.

\code{h5Attributes} will return a list containing all attributes for the 
given link.
}
\description{
Functions to get, set or delete HDF5 attributes for an existing link.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")

# Read H5 attribute
x <- h5Attr(file, "encoding-version")
x <- h5Attr(file, "column-order", "raw/var") ## An empty attribute
stopifnot(is.null(x))

h5obj <- h5Open(file, "raw/var", mode = "r")
x <- h5Attr(h5obj, "column-order")

# Read H5 attribute names
h5AttrNames(file)
h5AttrNames(file, "X")
h5AttrNames(h5obj)

# Read all H5 attributes
a1 <- h5Attributes(file, "raw/var")
a2 <- h5Attributes(h5obj)
stopifnot(identical(a1, a2))

# Write H5 attribute
tmp.file <- tempfile(fileext = ".h5")
file.copy(file, tmp.file)

new_a <- character()  # Can write an empty attribute
h5WriteAttr(tmp.file, "new_a", robj = new_a, name = "X")
new_a <- c("a", "b")
h5WriteAttr(tmp.file, "new_a", robj = new_a, name = "X", overwrite = TRUE)
h5Attr(tmp.file, "new_a", name = "X")

# Delete H5 attribute
h5DeleteAttr(tmp.file, "new_a", name = "X")
stopifnot(is.null(h5Attr(tmp.file, "new_a", name = "X")))

}
