// Generated by rstantools.  Do not edit by hand.

/*
    hbamr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hbamr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hbamr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_BAM_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_BAM");
    reader.add_event(69, 67, "end", "model_BAM");
    return reader;
}
#include <stan_meta_header.hpp>
class model_BAM
  : public stan::model::model_base_crtp<model_BAM> {
private:
        int N;
        int J;
        int N_obs;
        std::vector<int> ii;
        std::vector<int> jj;
        int B;
        int L;
        int R;
        std::vector<int> Y;
        vector_d V;
        int CV;
        std::vector<int> holdout;
        double tau_prior_rate;
public:
    model_BAM(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_BAM(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_BAM_namespace::model_BAM";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "N_obs", "int", context__.to_vec());
            N_obs = int(0);
            vals_i__ = context__.vals_i("N_obs");
            pos__ = 0;
            N_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_obs", N_obs, 1);
            current_statement_begin__ = 5;
            validate_non_negative_index("ii", "N_obs", N_obs);
            context__.validate_dims("data initialization", "ii", "int", context__.to_vec(N_obs));
            ii = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("ii");
            pos__ = 0;
            size_t ii_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < ii_k_0_max__; ++k_0__) {
                ii[k_0__] = vals_i__[pos__++];
            }
            size_t ii_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < ii_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ii[i_0__]", ii[i_0__], 1);
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("jj", "N_obs", N_obs);
            context__.validate_dims("data initialization", "jj", "int", context__.to_vec(N_obs));
            jj = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("jj");
            pos__ = 0;
            size_t jj_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < jj_k_0_max__; ++k_0__) {
                jj[k_0__] = vals_i__[pos__++];
            }
            size_t jj_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < jj_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "jj[i_0__]", jj[i_0__], 1);
            }
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "B", "int", context__.to_vec());
            B = int(0);
            vals_i__ = context__.vals_i("B");
            pos__ = 0;
            B = vals_i__[pos__++];
            check_greater_or_equal(function__, "B", B, 1);
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "L", "int", context__.to_vec());
            L = int(0);
            vals_i__ = context__.vals_i("L");
            pos__ = 0;
            L = vals_i__[pos__++];
            check_greater_or_equal(function__, "L", L, 1);
            check_less_or_equal(function__, "L", L, J);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            check_greater_or_equal(function__, "R", R, 1);
            check_less_or_equal(function__, "R", R, J);
            current_statement_begin__ = 10;
            validate_non_negative_index("Y", "N_obs", N_obs);
            context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N_obs));
            Y = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("Y");
            pos__ = 0;
            size_t Y_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < Y_k_0_max__; ++k_0__) {
                Y[k_0__] = vals_i__[pos__++];
            }
            size_t Y_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < Y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "Y[i_0__]", Y[i_0__], -(B));
                check_less_or_equal(function__, "Y[i_0__]", Y[i_0__], B);
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("V", "N", N);
            context__.validate_dims("data initialization", "V", "vector_d", context__.to_vec(N));
            V = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("V");
            pos__ = 0;
            size_t V_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < V_j_1_max__; ++j_1__) {
                V(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "V", V, -(B));
            check_less_or_equal(function__, "V", V, B);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "CV", "int", context__.to_vec());
            CV = int(0);
            vals_i__ = context__.vals_i("CV");
            pos__ = 0;
            CV = vals_i__[pos__++];
            check_greater_or_equal(function__, "CV", CV, 0);
            check_less_or_equal(function__, "CV", CV, 1);
            current_statement_begin__ = 13;
            validate_non_negative_index("holdout", "N_obs", N_obs);
            context__.validate_dims("data initialization", "holdout", "int", context__.to_vec(N_obs));
            holdout = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("holdout");
            pos__ = 0;
            size_t holdout_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < holdout_k_0_max__; ++k_0__) {
                holdout[k_0__] = vals_i__[pos__++];
            }
            size_t holdout_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < holdout_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "holdout[i_0__]", holdout[i_0__], 0);
                check_less_or_equal(function__, "holdout[i_0__]", holdout[i_0__], 1);
            }
            // initialize transformed data variables
            current_statement_begin__ = 17;
            tau_prior_rate = double(0);
            stan::math::fill(tau_prior_rate, DUMMY_VAR__);
            stan::math::assign(tau_prior_rate,((2 - 1) / (B / 5.0)));
            // execute transformed data statements
            // validate transformed data
            current_statement_begin__ = 17;
            check_greater_or_equal(function__, "tau_prior_rate", tau_prior_rate, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 21;
            validate_non_negative_index("alpha", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 22;
            validate_non_negative_index("beta", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 23;
            num_params_r__ += 1;
            current_statement_begin__ = 24;
            num_params_r__ += 1;
            current_statement_begin__ = 25;
            validate_non_negative_index("theta_raw", "J", J);
            num_params_r__ += (1 * J);
            current_statement_begin__ = 26;
            num_params_r__ += 1;
            current_statement_begin__ = 27;
            num_params_r__ += 1;
            current_statement_begin__ = 28;
            validate_non_negative_index("eta", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 29;
            validate_non_negative_index("rho", "J", J);
            num_params_r__ += (J - 1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_BAM() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 21;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "N", N);
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(N);
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "N", N);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(N);
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("thetal")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable thetal missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("thetal");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "thetal", "double", context__.to_vec());
        double thetal(0);
        thetal = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(-(1.1), -(.9), thetal);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable thetal: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("thetar")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable thetar missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("thetar");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "thetar", "double", context__.to_vec());
        double thetar(0);
        thetar = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(.9, 1.1, thetar);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable thetar: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("theta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_raw");
        pos__ = 0U;
        validate_non_negative_index("theta_raw", "J", J);
        context__.validate_dims("parameter initialization", "theta_raw", "double", context__.to_vec(J));
        std::vector<double> theta_raw(J, double(0));
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            theta_raw[k_0__] = vals_r__[pos__++];
        }
        size_t theta_raw_i_0_max__ = J;
        for (size_t i_0__ = 0; i_0__ < theta_raw_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(theta_raw[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(3, 30, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "N", N);
        context__.validate_dims("parameter initialization", "eta", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta(N);
        size_t eta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "J", J);
        context__.validate_dims("parameter initialization", "rho", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho(J);
        size_t rho_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            rho(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 21;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.vector_constrain(N, lp__);
            else
                alpha = in__.vector_constrain(N);
            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(N, lp__);
            else
                beta = in__.vector_constrain(N);
            current_statement_begin__ = 23;
            local_scalar_t__ thetal;
            (void) thetal;  // dummy to suppress unused var warning
            if (jacobian__)
                thetal = in__.scalar_lub_constrain(-(1.1), -(.9), lp__);
            else
                thetal = in__.scalar_lub_constrain(-(1.1), -(.9));
            current_statement_begin__ = 24;
            local_scalar_t__ thetar;
            (void) thetar;  // dummy to suppress unused var warning
            if (jacobian__)
                thetar = in__.scalar_lub_constrain(.9, 1.1, lp__);
            else
                thetar = in__.scalar_lub_constrain(.9, 1.1);
            current_statement_begin__ = 25;
            std::vector<local_scalar_t__> theta_raw;
            size_t theta_raw_d_0_max__ = J;
            theta_raw.reserve(theta_raw_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_raw_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta_raw.push_back(in__.scalar_constrain(lp__));
                else
                    theta_raw.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 26;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lub_constrain(3, 30, lp__);
            else
                nu = in__.scalar_lub_constrain(3, 30);
            current_statement_begin__ = 27;
            local_scalar_t__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0, lp__);
            else
                tau = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 28;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.vector_lb_constrain(0, N, lp__);
            else
                eta = in__.vector_lb_constrain(0, N);
            current_statement_begin__ = 29;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rho;
            (void) rho;  // dummy to suppress unused var warning
            if (jacobian__)
                rho = in__.simplex_constrain(J, lp__);
            else
                rho = in__.simplex_constrain(J);
            // transformed parameters
            current_statement_begin__ = 33;
            validate_non_negative_index("theta", "J", J);
            std::vector<local_scalar_t__> theta(J, local_scalar_t__(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 34;
            validate_non_negative_index("log_lik", "N_obs", N_obs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(N_obs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 35;
            local_scalar_t__ eta_scale;
            (void) eta_scale;  // dummy to suppress unused var warning
            stan::math::initialize(eta_scale, DUMMY_VAR__);
            stan::math::fill(eta_scale, DUMMY_VAR__);
            stan::math::assign(eta_scale,(tau * J));
            // transformed parameters block statements
            current_statement_begin__ = 36;
            stan::math::assign(theta, theta_raw);
            current_statement_begin__ = 37;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(L), stan::model::nil_index_list()), 
                        thetal, 
                        "assigning variable theta");
            current_statement_begin__ = 38;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(R), stan::model::nil_index_list()), 
                        thetar, 
                        "assigning variable theta");
            current_statement_begin__ = 39;
            for (int n = 1; n <= N_obs; ++n) {
                current_statement_begin__ = 40;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha, get_base1(ii, n, "ii", 1), "alpha", 1) + (get_base1(beta, get_base1(ii, n, "ii", 1), "beta", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), (stan::math::sqrt(get_base1(eta, get_base1(ii, n, "ii", 1), "eta", 1)) * get_base1(rho, get_base1(jj, n, "jj", 1), "rho", 1))), 
                            "assigning variable log_lik");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 33;
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(theta[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 34;
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_lik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_lik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 35;
            if (stan::math::is_uninitialized(eta_scale)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: eta_scale";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_scale: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "eta_scale", eta_scale, 0);
            // model body
            current_statement_begin__ = 46;
            lp_accum__.add(uniform_log<propto__>(alpha, -(100), 100));
            current_statement_begin__ = 47;
            lp_accum__.add(uniform_log<propto__>(beta, -(100), 100));
            current_statement_begin__ = 48;
            lp_accum__.add(normal_log<propto__>(theta_raw, 0, 1));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(thetal, 0, 1));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(thetar, 0, 1));
            current_statement_begin__ = 51;
            lp_accum__.add(scaled_inv_chi_square_log<propto__>(eta, nu, eta_scale));
            current_statement_begin__ = 52;
            lp_accum__.add(gamma_log<propto__>(nu, 25, 2.5));
            current_statement_begin__ = 53;
            lp_accum__.add(gamma_log<propto__>(tau, 2, (5 / (B * 1.0))));
            current_statement_begin__ = 54;
            lp_accum__.add(dirichlet_log<propto__>(rho, rep_vector(5, J)));
            current_statement_begin__ = 56;
            if (as_bool(logical_eq(CV, 0))) {
                current_statement_begin__ = 57;
                lp_accum__.add(sum(log_lik));
            } else {
                current_statement_begin__ = 59;
                for (int n = 1; n <= N_obs; ++n) {
                    current_statement_begin__ = 60;
                    if (as_bool(logical_eq(get_base1(holdout, n, "holdout", 1), 0))) {
                        current_statement_begin__ = 61;
                        lp_accum__.add(get_base1(log_lik, n, "log_lik", 1));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("thetal");
        names__.push_back("thetar");
        names__.push_back("theta_raw");
        names__.push_back("nu");
        names__.push_back("tau");
        names__.push_back("eta");
        names__.push_back("rho");
        names__.push_back("theta");
        names__.push_back("log_lik");
        names__.push_back("eta_scale");
        names__.push_back("chi");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_obs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_BAM_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.vector_constrain(N);
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(N);
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double thetal = in__.scalar_lub_constrain(-(1.1), -(.9));
        vars__.push_back(thetal);
        double thetar = in__.scalar_lub_constrain(.9, 1.1);
        vars__.push_back(thetar);
        std::vector<double> theta_raw;
        size_t theta_raw_d_0_max__ = J;
        theta_raw.reserve(theta_raw_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_raw_d_0_max__; ++d_0__) {
            theta_raw.push_back(in__.scalar_constrain());
        }
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            vars__.push_back(theta_raw[k_0__]);
        }
        double nu = in__.scalar_lub_constrain(3, 30);
        vars__.push_back(nu);
        double tau = in__.scalar_lb_constrain(0);
        vars__.push_back(tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta = in__.vector_lb_constrain(0, N);
        size_t eta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            vars__.push_back(eta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho = in__.simplex_constrain(J);
        size_t rho_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            vars__.push_back(rho(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 33;
            validate_non_negative_index("theta", "J", J);
            std::vector<double> theta(J, double(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 34;
            validate_non_negative_index("log_lik", "N_obs", N_obs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N_obs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 35;
            double eta_scale;
            (void) eta_scale;  // dummy to suppress unused var warning
            stan::math::initialize(eta_scale, DUMMY_VAR__);
            stan::math::fill(eta_scale, DUMMY_VAR__);
            stan::math::assign(eta_scale,(tau * J));
            // do transformed parameters statements
            current_statement_begin__ = 36;
            stan::math::assign(theta, theta_raw);
            current_statement_begin__ = 37;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(L), stan::model::nil_index_list()), 
                        thetal, 
                        "assigning variable theta");
            current_statement_begin__ = 38;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(R), stan::model::nil_index_list()), 
                        thetar, 
                        "assigning variable theta");
            current_statement_begin__ = 39;
            for (int n = 1; n <= N_obs; ++n) {
                current_statement_begin__ = 40;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha, get_base1(ii, n, "ii", 1), "alpha", 1) + (get_base1(beta, get_base1(ii, n, "ii", 1), "beta", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), (stan::math::sqrt(get_base1(eta, get_base1(ii, n, "ii", 1), "eta", 1)) * get_base1(rho, get_base1(jj, n, "jj", 1), "rho", 1))), 
                            "assigning variable log_lik");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            check_greater_or_equal(function__, "eta_scale", eta_scale, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_k_0_max__ = J;
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    vars__.push_back(theta[k_0__]);
                }
                size_t log_lik_j_1_max__ = N_obs;
                for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                    vars__.push_back(log_lik(j_1__));
                }
                vars__.push_back(eta_scale);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 66;
            validate_non_negative_index("chi", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> chi(N);
            stan::math::initialize(chi, DUMMY_VAR__);
            stan::math::fill(chi, DUMMY_VAR__);
            stan::math::assign(chi,elt_divide(subtract(V, alpha), beta));
            // validate, write generated quantities
            current_statement_begin__ = 66;
            size_t chi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
                vars__.push_back(chi(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_BAM";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "thetal";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "thetar";
        param_names__.push_back(param_name_stream__.str());
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t eta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_scale";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t chi_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "chi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "thetal";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "thetar";
        param_names__.push_back(param_name_stream__.str());
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t eta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_j_1_max__ = (J - 1);
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_scale";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t chi_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "chi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_BAM_namespace::model_BAM stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
