% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{HarmonyMatrix}
\alias{HarmonyMatrix}
\title{A proxy call to \code{\link[=RunHarmony]{RunHarmony()}}. Deprecated.}
\usage{
HarmonyMatrix(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=RunHarmony.default]{RunHarmony.default}}
  \describe{
    \item{\code{data_mat}}{Matrix of cell embeddings. Cells can be rows or
columns and will be inferred by the rows of meta_data.}
    \item{\code{meta_data}}{Either (1) Dataframe with variables to integrate
or (2) vector with labels.}
    \item{\code{vars_use}}{If meta_data is dataframe, this defined which
variable(s) to remove (character vector).}
    \item{\code{theta}}{Diversity clustering penalty parameter. Specify for
each variable in vars_use Default theta=2. theta=0 does not
encourage any diversity. Larger values of theta result in more
diverse clusters.}
    \item{\code{sigma}}{Width of soft kmeans clusters. Default
sigma=0.1. Sigma scales the distance from a cell to cluster
centroids. Larger values of sigma result in cells assigned to
more clusters. Smaller values of sigma make soft kmeans cluster
approach hard clustering.}
    \item{\code{lambda}}{Ridge regression penalty. Default lambda=1. Bigger
values protect against over correction. If several covariates
are specified, then lambda can also be a vector which needs to
be equal length with the number of variables to be
corrected. In this scenario, each covariate level group will be
assigned the scalars specified by the user. If set to NULL,
harmony will determine lambdas automatically and try to
minimize overcorrection (Use with caution still in beta testing).}
    \item{\code{nclust}}{Number of clusters in model. nclust=1 equivalent to
simple linear regression.}
    \item{\code{max_iter}}{Maximum number of rounds to run Harmony. One round
of Harmony involves one clustering and one correction step.}
    \item{\code{early_stop}}{Enable early stopping for harmony. The
harmonization process will stop when the change of objective
function between corrections drops below 1e-4}
    \item{\code{ncores}}{Number of processors to be used for math operations
when optimized BLAS is available. If BLAS is not supporting
multithreaded then this option has no effect. By default,
ncore=1 which runs as a single-threaded process. Although
Harmony supports multiple cores, it is not optimized for
multithreading. Increase this number for large datasets iff
single-core performance is not adequate.}
    \item{\code{plot_convergence}}{Whether to print the convergence plot of
the clustering objective function. TRUE to plot, FALSE to
suppress. This can be useful for debugging.}
    \item{\code{return_object}}{(Advanced Usage) Whether to return the Harmony
object or only the corrected PCA embeddings.}
    \item{\code{verbose}}{Whether to print progress messages. TRUE to print,
FALSE to suppress.}
    \item{\code{.options}}{Advanced parameters of RunHarmony. This must be the
result from a call to `harmony_options`. See ?`harmony_options`
for more details.}
  }}
}
\description{
Maintain name backwards compatibility with version 0 of
harmony. However, API is not backwards compatible with version
0. This function will be deprecated in later versions of Harmony.
}
