% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunHarmony.R, R/ui.R
\name{RunHarmony}
\alias{RunHarmony}
\alias{RunHarmony.Seurat}
\alias{RunHarmony.SingleCellExperiment}
\alias{HarmonyMatrix}
\title{Run harmony algorithm generic function}
\usage{
RunHarmony(...)

\method{RunHarmony}{Seurat}(
  object,
  group.by.vars,
  reduction.use = "pca",
  dims.use = NULL,
  verbose = TRUE,
  reduction.save = "harmony",
  project.dim = TRUE,
  ...
)

\method{RunHarmony}{SingleCellExperiment}(
  object,
  group.by.vars,
  dims.use = NULL,
  verbose = TRUE,
  reduction.save = "HARMONY",
  ...
)

HarmonyMatrix(...)
}
\arguments{
\item{...}{harmony algorithm parameters to be passed on RunHarmony.default}

\item{object}{SingleCellExperiment with the PCA reducedDim cell embeddings populated}

\item{group.by.vars}{the name(s) of covariates that harmony will remove
its effect on the data.}

\item{reduction.use}{Name of dimension reduction to use. Default is pca.}

\item{dims.use}{a vector of indices that allows only selected cell embeddings
features to be used.}

\item{verbose}{enable verbosity}

\item{reduction.save}{the name of the new slot that is going to be created by
harmony. By default, HARMONY.}

\item{project.dim}{Project dimension reduction loadings. Default TRUE.}
}
\value{
Seurat object. Harmony dimensions placed into a new slot in the Seurat
object according to the reduction.save. For downstream Seurat analyses,
use reduction='harmony'.

SingleCellExperiment object. After running RunHarmony, the corrected
cell embeddings can be accessed with reducedDim(object, "Harmony").
}
\description{
This is a generic that provides wrappers for Seurat and SingleCellExperiment
objects. Also, it allows harmony standalone with a matrix and a metadata
dataframe.
}
