% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{map,hbr-method}
\alias{map}
\alias{map,hbr-method}
\alias{map.hbr}
\title{Map from reconstructed haplotype-blocks to windows}
\usage{
\S4method{map}{hbr}(object)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of reconstructed 
haplotype-blocks}
}
\value{
list with elements corresponding to all reconstructed haplotype-blocks (id for all
blocks without filtering based on the number of markers). Each element contains a vector of
window indices that are contained in the block
}
\description{
A method returning information which windows are contain in which reconstructed
haplotype-block.
}
\details{
The method operates on \code{\link{hbr}} objects and returns a list summarizing
the mapping information from reconstructed haplotype-blocks to contained windows.
NOTE: A window is only listed for a haplotype-block when at least \code{min.inter}
many markers of the block are in that window.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

