% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/members.R
\name{members}
\alias{members}
\title{All Members of Parliament}
\usage{
members(house = c("all", "commons", "lords", "lordsInterests"))
}
\arguments{
\item{house}{The type of data you want, allows the arguments 'all', 'commons', 'lords', 'lordsInterests'}

\item{all}{Returns a data frame with information on all members of Parliament, including both the House of Lords and the House of Commons. The data frame includes both current and previous members, and the API currently does not have information on when a member first sat in the house, or to distinguish current from former members.}

\item{commons}{Returns a data frame with information on all members of the House of Commons. The data frame includes both current and previous members of the House of Commons, and the API currently does not have information on when a member first sat in the house, or to distinguish current from former members.}

\item{lords}{Returns a data frame with all available members of the House of Lords.}

\item{lordsInterests}{Requests a member ID, and returns a data frame of the registered interests of that member of the House of Lords.}
}
\description{
Imports data on All Members of Parliament including the Lords and the Commons
}
\examples{
\dontrun{
x <- members('all')

x <- members('commons')

x <- members('lords')

b <- members('lordsInterests')
}
}
\keyword{All}
\keyword{Members}
\keyword{Parliament}
\keyword{of}

