% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_basis_filter.R
\name{make_reduced_basis_map}
\alias{make_reduced_basis_map}
\title{Mass-based reduction of basis functions}
\usage{
make_reduced_basis_map(x_basis, reduce_basis_crit)
}
\arguments{
\item{x_basis}{A matrix of basis functions with all redundant basis
functions already removed.}

\item{reduce_basis_crit}{A scalar \code{numeric} value bounded in the open
interval (0,1) indicating the minimum proportion of 1's in a basis function
column needed for the basis function to be included in the procedure to fit
the Lasso. Any basis functions with a lower proportion of 1's than the
specified cutoff will be removed. This argument defaults to \code{NULL}, in
which case all basis functions are used in the lasso-fitting stage of the
HAL algorithm.}
}
\value{
A binary \code{numeric} vector indicating which columns of the
matrix of basis functions to keep (given a one) and which to discard (given
a zero).
}
\description{
A helper function that finds which basis functions to keep (and equivalently
which to discard) based on the proportion of 1's (observations, i.e.,
"mass") included in a given basis function.
}
