% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.hal9001}
\alias{predict.hal9001}
\title{Prediction from HAL fits}
\usage{
\method{predict}{hal9001}(
  object,
  offset = NULL,
  lambda = NULL,
  ...,
  new_data,
  new_X_unpenalized = NULL
)
}
\arguments{
\item{object}{An object of class \code{hal9001}, containing the results of
fitting the Highly Adaptive Lasso, as produced by a call to \code{fit_hal}.}

\item{offset}{A vector of offsets. Must be provided if provided at training}

\item{lambda}{A single lambda value or a vector of lambdas to use for
prediction. If \code{NULL}, a value of lambda will be selected based on
cross-validation, using \code{\link[glmnet]{cv.glmnet}}.}

\item{...}{Additional arguments passed to \code{predict} as necessary.}

\item{new_data}{A \code{matrix} or \code{data.frame} containing new data
(observations NOT used in fitting the \code{hal9001} object passed in via
the \code{object} argument above) for which the \code{hal9001} object will
compute predicted values.}

\item{new_X_unpenalized}{If the user supplied \code{X_unpenalized} during
training, the user should also supply this matrix with the same number of
observations as \code{new_data}. Optional.}
}
\value{
A \code{numeric} vector of predictions from a fitted \code{hal9001}
 object.
}
\description{
Prediction from HAL fits
}
\details{
Method for computing and extracting predictions from fits of the
 Highly Adaptive Lasso estimator, returned as a single S3 objects of class
 \code{hal9001}.
}
