% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hydra.R
\name{hail_hydra}
\alias{hail_hydra}
\title{Read HYDRA data}
\usage{
hail_hydra(stations = "all")
}
\arguments{
\item{stations}{a vector of station names you want the information for;
these values can be retrieved from the \code{\link{hydra_data}} dataset.
By default, the value is "all", meaning data is retrieved for every station.}
}
\value{
a data.frame containing columns representing the date, daily total
rainfall inches, station, and hourly breakdowns.
}
\description{
\code{hail_hydra} reads hourly rainfall data from
the HYDRA network of rain gages around Portland, Oregon. This
data is preliminary and raw, meaning that it is likely to contain
missing or corrupt values; efforts have been made to ensure such values
come out as NAs.
}
\examples{
# Simple exmaple
walmart_data <- hail_hydra("Walmart Eco Roof")
}

