% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixfit.R
\name{subtract.excitedstates}
\alias{subtract.excitedstates}
\title{Substract excited states.}
\usage{
subtract.excitedstates(cf, mfit, from.samples = FALSE)
}
\arguments{
\item{cf}{Correlation function of class \code{cf}.}

\item{mfit}{Fit result of class \code{matrixfit}.}

\item{from.samples}{Whether to use existing bootstrap samples. If set to
\code{TRUE}, the same operation will be applied to the bootstrap samples.
Otherwise the result will not contain bootstrap samples, even if the input
correlation function did.}
}
\value{
A correlation function of class \code{cf} which is computed from the old
correlation function \eqn{C(t)} as \eqn{M(t) + C(t) - \bar{C}(t)}, where
\eqn{M(t)} is the fit model and \eqn{\bar{C}(t)} denotes the average over
the (bootstrap) samples. Only time slices earlier than the fit are altered.
}
\description{
Excited states are subtracted from the given correlation function and
matching matrixfit. The fit is usually done on late time slices when the
thermal states have decayed so much that they can be neglected. On the early
time slices there are contributions which cannot be explained with a single
cosh (or sinh) function. These are exactly the contributions that we do not
want.
}
\details{
The correlation function is altered on the time slices which are earlier than
the start of the fit interval. The correlator is replaced by the model
function (cosh or sinh or exp) extrapolated until the first time slice. The
deviations of the (bootstrap) samples from the mean value are kept.
}
