% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectivemass.R
\name{fit.effectivemass}
\alias{fit.effectivemass}
\title{Fits a constant to effective mass data}
\usage{
fit.effectivemass(cf, t1, t2, useCov = FALSE, replace.na = TRUE,
  boot.fit = TRUE, autoproceed = FALSE, every)
}
\arguments{
\item{cf}{An object of class \code{effectivemass} generated by a call to
\code{bootstrap.effectivemass}.}

\item{t1, t2}{The fit range. If several correlators are fitted, this is
automatically replicated accordingly. The fit range is adjusted such that
\code{NA}s are removed from the fit. They must fulfill \eqn{t_1<t_2}{t1<t2}.
For symmetric correlators, they must both run from 0 to \code{Time/2-1},
otherwise from 0 to \code{Time-1}.}

\item{useCov}{Use the correlated chisquare. This works only for not too
noisy data.}

\item{replace.na}{The functions inverted to determine the effective mass
values might, due to fluctuations, return \code{NA}. If
\code{replace.na=TRUE}, these are reaplaced in the bootstrap samples by
randomly chosen values from the distribution that are not \code{NA}.
Otherwise the fits in which the \code{NA} values occur will fail.}

\item{boot.fit}{If set to \code{FALSE}, the effective mass fit is not
bootstrapped, even though bootstrap samples are still used to estimate the
variance-covariance matrix for the correlated fit. This is a useful
time-saver if error information is not strictly necessary. Of course, this
affects the return values related to the bootstrap, which are set to
\code{NA}.}

\item{autoproceed}{When the inversion of the variance-covariance matrix
fails, the default behaviour is to abort the fit. Setting this to
\code{TRUE} means that the fit is instead continued with a diagonal inverse
of the variance-covariance matrix.}

\item{every}{Fit only a part of the data points. Indices that are not
multiples of \code{every} are skipped. If no value is provided, all points
are taken into account.}
}
\value{
An object with class \code{effectivemassfit} is returned. It
contains all the data of the input object \code{effMass} with the following
additional member objects:

\code{opt.res}: the object returned by the \code{optim} on the original
data.

\code{massfit.tsboot}: the bootstrap values of the mass and the chisquare
function.

\code{ii}: the index array of data used in the fit.

\code{invCovMatrix}: the inverse covariance matrix.

\code{dof}: the degrees of freedom of the fit.

\code{t1,t2}: the fit range.
}
\description{
Performs a correlated fit of a constant to data generated with
\code{bootstrap.effectivemass}.
}
\details{
A correlated chisquare minimisation is performed on the original data as
well as on all bootstrap samples generated by
\code{bootstrap.effectivemass}. The inverse covariance matrix is generated
as described in hep-lat/9412087 in case of too little data to relibably
estimate it.
}
\examples{

data(samplecf)
samplecf <- bootstrap.cf(cf=samplecf, boot.R=99, boot.l=2, seed=1442556)
effmass <- fit.effectivemass(bootstrap.effectivemass(cf=samplecf), t1=15, t2=23)
summary(effmass)
plot(effmass, ylim=c(0.14,0.15))

}
\references{
C.Michael, A.McKerrell, Phys.Rev. D51 (1995) 3745-3750,
hep-lat/9412087
}
\seealso{
\code{\link{bootstrap.effectivemass}},
\code{\link{bootstrap.gevp}}, \code{\link{gevp2cf}},
\code{\link{invertCovMatrix}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{optim}
