% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looptools.R
\name{loop_vev_subtract}
\alias{loop_vev_subtract}
\title{subtract vev from loop data}
\usage{
loop_vev_subtract(loop, nstoch_to_avg = "all")
}
\arguments{
\item{loop}{'raw_cf' container with loop data}

\item{nstoch_to_avg}{String or integer, number of stochastic samples
to average over. Only possible string is 'all'. If an
integer is provided it must be at least '1' and at most
consistent with the number of stochastic samples in \code{loop}.}
}
\value{
Returns the input \code{loop} object with added data.
}
\description{
Convenience function to subtract any possible vacuum-expectation
value from a loop matrix. The expectation value of each component
of the internal dimensions is subtracted individually.
Averaging over stochstic samples can be restricted to a subset, see
\code{nstoch_to_avg} input parameter.
}
