% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{if_else_}
\alias{if_else_}
\title{if_this_else_that_}
\usage{
if_else_(condition, true, false, missing = NULL)
}
\arguments{
\item{condition}{logical vector}

\item{true}{value to replace if condition is true. Must be same length as condition or 1.}

\item{false}{value to replace if condition is false. Must be same length as condition or 1.}

\item{missing}{optional. a replacement if condition returns NA. Must be same length as condition or 1.}
}
\value{
a vector
}
\description{
A vectorised if or else function. It checks that the true or false (or the optional missing)
arguments have the same type. However it accepts a generic NA. Built upon
dplyr's [if_else()] function. The only difference is that the user do not have to specify
the type of NA. if_else_ is faster than base [ifelse()] and a tad slower than 
dplyr's [if_else()]. Attributes are taken from either true or false because one
generic NA.
}
\details{
If the returning vector have attributes (e.g. for factors) it returns the attributes
for the first non-generic NA in the order true, false and then missing.
}
\examples{

v <- c(TRUE, FALSE, TRUE, FALSE)
if_else_(v, "true", "false")

v <- c(TRUE, FALSE, NA, FALSE)
if_else_(v, 1, NA, 999)

}
\seealso{
\code{vignette("s")}, \code{vignette("hablar")}
}
