% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{convert}
\alias{convert}
\alias{num}
\alias{chr}
\alias{lgl}
\alias{int}
\alias{dbl}
\alias{fct}
\alias{dtm}
\alias{dte}
\title{Convert data type of columns}
\usage{
num(..., .args = list())

chr(..., .args = list())

lgl(..., .args = list())

int(..., .args = list())

dbl(..., .args = list())

fct(..., .args = list())

dtm(..., .args = list())

dte(..., .args = list())

convert(.x, ...)
}
\arguments{
\item{...}{Scoping functions, see details}

\item{.args}{extra argument to be passed to support function.}

\item{.x}{A data.frame}
}
\value{
a tbl data frame
}
\description{
Convert data type of columns
}
\examples{
\dontrun{

# Change one column to numeric and another to character
mtcars \%>\% 
  convert(num(gear),
          chr(mpg))


# Changing multiple data types on multiple columns
mtcars \%>\% 
  convert(int(hp,
              wt),
          fct(qsec,
              cyl,
              drat))

# Also works with tidyselect convenience functions
mtcars \%>\%
  convert(int(vs:carb),
          fct(last_col()))

}

}
\seealso{
\code{vignette("convert")}, \code{vignette("hablar")}
}
