% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pstRT_ddm.R
\name{pstRT_ddm}
\alias{pstRT_ddm}
\title{Drift Diffusion Model}
\usage{
pstRT_ddm(
  data = NULL,
  niter = 4000,
  nwarmup = 1000,
  nchain = 4,
  ncore = 1,
  nthin = 1,
  inits = "vb",
  indPars = "mean",
  modelRegressor = FALSE,
  vb = FALSE,
  inc_postpred = FALSE,
  adapt_delta = 0.95,
  stepsize = 1,
  max_treedepth = 10,
  ...
)
}
\arguments{
\item{data}{Data to be modeled. It should be given as a data.frame object,
a filepath for a tab-seperated txt file, \code{"example"} to use example data, or
\code{"choose"} to choose data with an interactive window.
Columns in the dataset must include:
"subjID", "cond", "choice", "RT". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up. Defaults to 4000.}

\item{nwarmup}{Number of iterations used for warm-up only. Defaults to 1000.}

\item{nchain}{Number of Markov chains to run. Defaults to 4.}

\item{ncore}{Number of CPUs to be used for running. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution.
Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is
high.}

\item{inits}{Character value specifying how the initial values should be generated.
Possible options are "vb" (default), "fixed", "random", or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options
are: "mean", "median", or "mode".}

\item{modelRegressor}{Whether to export model-based regressors (\code{TRUE} or \code{FALSE}).
Not available for this model.}

\item{vb}{Use variational inference to approximately draw from a posterior distribution. Defaults
to \code{FALSE}.}

\item{inc_postpred}{Include trial-level posterior predictive simulations in model output (may greatly increase file
size). Defaults to \code{FALSE}.
If set to \code{TRUE}, it includes: "choice_os", "RT_os"}

\item{adapt_delta}{Floating point value representing the target acceptance probability of a new
sample in the MCMC chain. Must be between 0 and 1. See \bold{Details} below.}

\item{stepsize}{Integer value specifying the size of each leapfrog step that the MCMC sampler can
take on each new iteration. See \bold{Details} below.}

\item{max_treedepth}{Integer value specifying how many leapfrog steps the MCMC sampler can take
on each new iteration. See \bold{Details} below.}

\item{...}{For this model, it's possible to set \strong{model-specific argument(s)} as follows: 
\describe{
  \item{RTbound}{Floating point value representing the lower bound (i.e., minimum allowed) reaction time. Defaults to 0.1 (100 milliseconds).}
  
  
  
  
  
  
  
  
}}
}
\value{
A class "hBayesDM" object \code{modelData} with the following components:
\describe{
  \item{model}{Character value that is the name of the model (\\code{"pstRT_ddm"}).}
  \item{allIndPars}{Data.frame containing the summarized parameter values (as specified by
    \code{indPars}) for each subject.}
  \item{parVals}{List object containing the posterior samples over different parameters.}
  \item{fit}{A class \code{\link[rstan]{stanfit}} object that contains the fitted Stan
    model.}
  \item{rawdata}{Data.frame containing the raw data used to fit the model, as specified by
    the user.}
  
  
  \item{modelRegressor}{List object containing the extracted model-based regressors.}
}
}
\description{
Hierarchical Bayesian Modeling of the Probabilistic Selection Task (with RT data) using Drift Diffusion Model.
It has the following parameters: \code{a} (boundary separation), \code{tau} (non-decision time), \code{d1} (drift rate scaling), \code{d2} (drift rate scaling), \code{d3} (drift rate scaling).

\itemize{
  \item \strong{Task}: Probabilistic Selection Task (with RT data) (Frank et al., 2007; Frank et al., 2004)
  \item \strong{Model}: Drift Diffusion Model (Pedersen et al., 2017)
}
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name (including
  extension information, e.g. ".txt") of the file that contains the behavioral data-set of all
  subjects of interest for the current analysis. The file should be a \strong{tab-delimited} text
  file, whose rows represent trial-by-trial observations and columns represent variables.\cr
For the Probabilistic Selection Task (with RT data), there should be 4 columns of data with the
  labels "subjID", "cond", "choice", "RT". It is not necessary for the columns to be in this particular order,
  however it is necessary that they be labeled correctly and contain the information below:
\describe{
  \item{subjID}{A unique identifier for each subject in the data-set.}
  \item{cond}{Integer value representing the task condition of the given trial (AB == 1, CD == 2, EF == 3).}
  \item{choice}{Integer value representing the option chosen on the given trial (1 or 2).}
  \item{RT}{Float value representing the time taken for the response on the given trial.}
  
  
  
  
  
}
\strong{*}Note: The file may contain other columns of data (e.g. "ReactionTime", "trial_number",
  etc.), but only the data within the column names listed above will be used during the modeling.
  As long as the necessary columns mentioned above are present and labeled correctly, there is no
  need to remove other miscellaneous data columns.

\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored
  upon the beginning of each chain. For those familiar with Bayesian methods, this is equivalent
  to burn-in samples. Due to the nature of the MCMC algorithm, initial values (i.e. where the
  sampling chains begin) can have a heavy influence on the generated posterior distributions. The
  \code{nwarmup} argument can be set to a high number in order to curb the effects that initial
  values have on the resulting posteriors.

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling
  sequences) should be used to draw samples from the posterior distribution. Since the posteriors
  are generated from a sampling process, it is good practice to run multiple chains to ensure
  that a reasonably representative posterior is attained. When the sampling is complete, it is
  possible to check the multiple chains for convergence by running the following line of code:
  \code{plot(output, type = "trace")}. The trace-plot should resemble a "furry caterpillar".

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC sampler,
  using only every \code{i == nthin} samples to generate posterior distributions. By default,
  \code{nthin} is equal to 1, meaning that every sample is used to generate the posterior.

\strong{Control Parameters:} \code{adapt_delta}, \code{stepsize}, and \code{max_treedepth} are
  advanced options that give the user more control over Stan's MCMC sampler. It is recommended
  that only advanced users change the default values, as alterations can profoundly change the
  sampler's behavior. Refer to 'The No-U-Turn Sampler: Adaptively Setting Path Lengths in
  Hamiltonian Monte Carlo (Hoffman & Gelman, 2014, Journal of Machine Learning Research)' for
  more information on the sampler control parameters. One can also refer to 'Section 34.2. HMC
  Algorithm Parameters' of the \href{https://mc-stan.org/users/documentation/}{Stan User's Guide
  and Reference Manual}, or to the help page for \code{\link[rstan]{stan}} for a less technical
  description of these arguments.

\subsection{Contributors}{\href{https://hydoh.github.io/}{Hoyoung Doh} <\email{hoyoung.doh@gmail.com}>, \href{https://medicine.yale.edu/lab/goldfarb/profile/sanghoon_kang/}{Sanghoon Kang} <\email{sanghoon.kang@yale.edu}>, \href{https://jihyuncindyhur.github.io/}{Jihyun K. Hur} <\email{jihyun.hur@yale.edu}>}
}
\examples{
\dontrun{
# Run the model with a given data.frame as df
output <- pstRT_ddm(
  data = df, niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Run the model with example data
output <- pstRT_ddm(
  data = "example", niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Visually check convergence of the sampling chains (should look like 'hairy caterpillars')
plot(output, type = "trace")

# Check Rhat values (all Rhat values should be less than or equal to 1.1)
rhat(output)

# Plot the posterior distributions of the hyper-parameters (distributions should be unimodal)
plot(output)

# Show the WAIC and LOOIC model fit estimates
printFit(output)
}
}
\references{
Frank, M. J., Santamaria, A., O'Reilly, R. C., & Willcutt, E. (2007). Testing computational models of dopamine and noradrenaline dysfunction in attention deficit/hyperactivity disorder. Neuropsychopharmacology, 32(7), 1583-1599.

Frank, M. J., Seeberger, L. C., & O'reilly, R. C. (2004). By carrot or by stick: cognitive reinforcement learning in parkinsonism. Science, 306(5703), 1940-1943.

Pedersen, M. L., Frank, M. J., & Biele, G. (2017). The drift diffusion model as the choice rule in reinforcement learning. Psychonomic bulletin & review, 24(4), 1234-1251.
}
\seealso{
We refer users to our in-depth tutorial for an example of using hBayesDM:
  \url{https://rpubs.com/CCSL/hBayesDM}
}
