/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_peer_ocu_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_peer_ocu");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_peer_ocu");
    reader.add_event(129, 114, "end", "model_peer_ocu");
    return reader;
}

#include <meta_header.hpp>
 class model_peer_ocu : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > condition;
    vector<vector<double> > p_gamble;
    vector<vector<double> > safe_Hpayoff;
    vector<vector<double> > safe_Lpayoff;
    vector<vector<double> > risky_Hpayoff;
    vector<vector<double> > risky_Lpayoff;
    vector<vector<int> > choice;
public:
    model_peer_ocu(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_peer_ocu(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_peer_ocu_namespace::model_peer_ocu";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("condition", "N", N);
            validate_non_negative_index("condition", "T", T);
            context__.validate_dims("data initialization", "condition", "int", context__.to_vec(N,T));
            validate_non_negative_index("condition", "N", N);
            validate_non_negative_index("condition", "T", T);
            condition = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("condition");
            pos__ = 0;
            size_t condition_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < condition_limit_1__; ++i_1__) {
                size_t condition_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < condition_limit_0__; ++i_0__) {
                    condition[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("p_gamble", "N", N);
            validate_non_negative_index("p_gamble", "T", T);
            context__.validate_dims("data initialization", "p_gamble", "double", context__.to_vec(N,T));
            validate_non_negative_index("p_gamble", "N", N);
            validate_non_negative_index("p_gamble", "T", T);
            p_gamble = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("p_gamble");
            pos__ = 0;
            size_t p_gamble_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < p_gamble_limit_1__; ++i_1__) {
                size_t p_gamble_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < p_gamble_limit_0__; ++i_0__) {
                    p_gamble[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("safe_Hpayoff", "N", N);
            validate_non_negative_index("safe_Hpayoff", "T", T);
            context__.validate_dims("data initialization", "safe_Hpayoff", "double", context__.to_vec(N,T));
            validate_non_negative_index("safe_Hpayoff", "N", N);
            validate_non_negative_index("safe_Hpayoff", "T", T);
            safe_Hpayoff = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("safe_Hpayoff");
            pos__ = 0;
            size_t safe_Hpayoff_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < safe_Hpayoff_limit_1__; ++i_1__) {
                size_t safe_Hpayoff_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < safe_Hpayoff_limit_0__; ++i_0__) {
                    safe_Hpayoff[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("safe_Lpayoff", "N", N);
            validate_non_negative_index("safe_Lpayoff", "T", T);
            context__.validate_dims("data initialization", "safe_Lpayoff", "double", context__.to_vec(N,T));
            validate_non_negative_index("safe_Lpayoff", "N", N);
            validate_non_negative_index("safe_Lpayoff", "T", T);
            safe_Lpayoff = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("safe_Lpayoff");
            pos__ = 0;
            size_t safe_Lpayoff_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < safe_Lpayoff_limit_1__; ++i_1__) {
                size_t safe_Lpayoff_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < safe_Lpayoff_limit_0__; ++i_0__) {
                    safe_Lpayoff[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("risky_Hpayoff", "N", N);
            validate_non_negative_index("risky_Hpayoff", "T", T);
            context__.validate_dims("data initialization", "risky_Hpayoff", "double", context__.to_vec(N,T));
            validate_non_negative_index("risky_Hpayoff", "N", N);
            validate_non_negative_index("risky_Hpayoff", "T", T);
            risky_Hpayoff = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("risky_Hpayoff");
            pos__ = 0;
            size_t risky_Hpayoff_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < risky_Hpayoff_limit_1__; ++i_1__) {
                size_t risky_Hpayoff_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < risky_Hpayoff_limit_0__; ++i_0__) {
                    risky_Hpayoff[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 25;
            validate_non_negative_index("risky_Lpayoff", "N", N);
            validate_non_negative_index("risky_Lpayoff", "T", T);
            context__.validate_dims("data initialization", "risky_Lpayoff", "double", context__.to_vec(N,T));
            validate_non_negative_index("risky_Lpayoff", "N", N);
            validate_non_negative_index("risky_Lpayoff", "T", T);
            risky_Lpayoff = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("risky_Lpayoff");
            pos__ = 0;
            size_t risky_Lpayoff_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < risky_Lpayoff_limit_1__; ++i_1__) {
                size_t risky_Lpayoff_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < risky_Lpayoff_limit_0__; ++i_0__) {
                    risky_Lpayoff[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"condition[k0__][k1__]",condition[k0__][k1__],0);
                    check_less_or_equal(function__,"condition[k0__][k1__]",condition[k0__][k1__],3);
                }
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"p_gamble[k0__][k1__]",p_gamble[k0__][k1__],0);
                    check_less_or_equal(function__,"p_gamble[k0__][k1__]",p_gamble[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 22;
            current_statement_begin__ = 23;
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],-(1));
                    check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                }
            }
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 33;
            validate_non_negative_index("mu_pr", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 34;
            validate_non_negative_index("sigma", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 35;
            validate_non_negative_index("rho_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 36;
            validate_non_negative_index("tau_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 37;
            validate_non_negative_index("ocu_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_peer_ocu() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "3", 3);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(3));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "3", 3);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        validate_non_negative_index("rho_pr", "N", N);
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        validate_non_negative_index("tau_pr", "N", N);
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        if (!(context__.contains_r("ocu_pr")))
            throw std::runtime_error("variable ocu_pr missing");
        vals_r__ = context__.vals_r("ocu_pr");
        pos__ = 0U;
        validate_non_negative_index("ocu_pr", "N", N);
        context__.validate_dims("initialization", "ocu_pr", "vector_d", context__.to_vec(N));
        vector_d ocu_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ocu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ocu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ocu_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(3,lp__);
            else
                mu_pr = in__.vector_constrain(3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,3,lp__);
            else
                sigma = in__.vector_lb_constrain(0,3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho_pr;
            (void) rho_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                rho_pr = in__.vector_constrain(N,lp__);
            else
                rho_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau_pr;
            (void) tau_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_pr = in__.vector_constrain(N,lp__);
            else
                tau_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ocu_pr;
            (void) ocu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                ocu_pr = in__.vector_constrain(N,lp__);
            else
                ocu_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 41;
            validate_non_negative_index("rho", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
            (void) rho;  // dummy to suppress unused var warning

            stan::math::initialize(rho, DUMMY_VAR__);
            stan::math::fill(rho,DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("ocu", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ocu(static_cast<Eigen::VectorXd::Index>(N));
            (void) ocu;  // dummy to suppress unused var warning

            stan::math::initialize(ocu, DUMMY_VAR__);
            stan::math::fill(ocu,DUMMY_VAR__);


            current_statement_begin__ = 45;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 46;
                stan::model::assign(rho, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_pr,i,"rho_pr",1)))) * 2), 
                            "assigning variable rho");
            }
            current_statement_begin__ = 48;
            stan::math::assign(tau, stan::math::exp(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),tau_pr))));
            current_statement_begin__ = 49;
            stan::math::assign(ocu, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),ocu_pr)));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(rho(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(tau(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(ocu(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ocu" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"rho",rho,0);
            check_less_or_equal(function__,"rho",rho,2);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 43;

            // model body

            current_statement_begin__ = 55;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1.0));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(sigma, stan::model::cons_list(stan::model::index_min_max(1, 2), stan::model::nil_index_list()), "sigma"), 0, 0.20000000000000001));
            current_statement_begin__ = 57;
            lp_accum__.add(cauchy_log<propto__>(get_base1(sigma,3,"sigma",1), 0, 1.0));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1.0));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(ocu_pr, 0, 1.0));
            current_statement_begin__ = 64;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 65;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 66;
                    local_scalar_t__ U_safe;
                    (void) U_safe;  // dummy to suppress unused var warning

                    stan::math::initialize(U_safe, DUMMY_VAR__);
                    stan::math::fill(U_safe,DUMMY_VAR__);
                    current_statement_begin__ = 67;
                    local_scalar_t__ U_risky;
                    (void) U_risky;  // dummy to suppress unused var warning

                    stan::math::initialize(U_risky, DUMMY_VAR__);
                    stan::math::fill(U_risky,DUMMY_VAR__);


                    current_statement_begin__ = 69;
                    stan::math::assign(U_safe, ((get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2) * pow(get_base1(get_base1(safe_Hpayoff,i,"safe_Hpayoff",1),t,"safe_Hpayoff",2),get_base1(rho,i,"rho",1))) + ((1 - get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2)) * pow(get_base1(get_base1(safe_Lpayoff,i,"safe_Lpayoff",1),t,"safe_Lpayoff",2),get_base1(rho,i,"rho",1)))));
                    current_statement_begin__ = 70;
                    stan::math::assign(U_risky, ((get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2) * pow(get_base1(get_base1(risky_Hpayoff,i,"risky_Hpayoff",1),t,"risky_Hpayoff",2),get_base1(rho,i,"rho",1))) + ((1 - get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2)) * pow(get_base1(get_base1(risky_Lpayoff,i,"risky_Lpayoff",1),t,"risky_Lpayoff",2),get_base1(rho,i,"rho",1)))));
                    current_statement_begin__ = 71;
                    if (as_bool(logical_eq(get_base1(get_base1(condition,i,"condition",1),t,"condition",2),1))) {

                        current_statement_begin__ = 72;
                        stan::math::assign(U_safe, (U_safe + get_base1(ocu,i,"ocu",1)));
                    }
                    current_statement_begin__ = 74;
                    if (as_bool(logical_eq(get_base1(get_base1(condition,i,"condition",1),t,"condition",2),3))) {

                        current_statement_begin__ = 75;
                        stan::math::assign(U_risky, (U_risky + get_base1(ocu,i,"ocu",1)));
                    }
                    current_statement_begin__ = 77;
                    lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), (get_base1(tau,i,"tau",1) * (U_risky - U_safe))));
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("rho_pr");
        names__.push_back("tau_pr");
        names__.push_back("ocu_pr");
        names__.push_back("rho");
        names__.push_back("tau");
        names__.push_back("ocu");
        names__.push_back("mu_rho");
        names__.push_back("mu_tau");
        names__.push_back("mu_ocu");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_peer_ocu_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d rho_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
        vector_d ocu_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ocu_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 41;
            validate_non_negative_index("rho", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
            (void) rho;  // dummy to suppress unused var warning

            stan::math::initialize(rho, DUMMY_VAR__);
            stan::math::fill(rho,DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("ocu", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ocu(static_cast<Eigen::VectorXd::Index>(N));
            (void) ocu;  // dummy to suppress unused var warning

            stan::math::initialize(ocu, DUMMY_VAR__);
            stan::math::fill(ocu,DUMMY_VAR__);


            current_statement_begin__ = 45;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 46;
                stan::model::assign(rho, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_pr,i,"rho_pr",1)))) * 2), 
                            "assigning variable rho");
            }
            current_statement_begin__ = 48;
            stan::math::assign(tau, stan::math::exp(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),tau_pr))));
            current_statement_begin__ = 49;
            stan::math::assign(ocu, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),ocu_pr)));

            // validate transformed parameters
            current_statement_begin__ = 41;
            check_greater_or_equal(function__,"rho",rho,0);
            check_less_or_equal(function__,"rho",rho,2);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 43;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ocu[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 82;
            local_scalar_t__ mu_rho;
            (void) mu_rho;  // dummy to suppress unused var warning

            stan::math::initialize(mu_rho, DUMMY_VAR__);
            stan::math::fill(mu_rho,DUMMY_VAR__);
            current_statement_begin__ = 83;
            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning

            stan::math::initialize(mu_tau, DUMMY_VAR__);
            stan::math::fill(mu_tau,DUMMY_VAR__);
            current_statement_begin__ = 84;
            local_scalar_t__ mu_ocu;
            (void) mu_ocu;  // dummy to suppress unused var warning

            stan::math::initialize(mu_ocu, DUMMY_VAR__);
            stan::math::fill(mu_ocu,DUMMY_VAR__);
            current_statement_begin__ = 87;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 93;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 94;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 95;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 99;
            stan::math::assign(mu_rho, (Phi_approx(get_base1(mu_pr,1,"mu_pr",1)) * 2));
            current_statement_begin__ = 100;
            stan::math::assign(mu_tau, stan::math::exp(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 101;
            stan::math::assign(mu_ocu, get_base1(mu_pr,3,"mu_pr",1));

            current_statement_begin__ = 104;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 107;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0.0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 109;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 110;
                    local_scalar_t__ U_safe;
                    (void) U_safe;  // dummy to suppress unused var warning

                    stan::math::initialize(U_safe, DUMMY_VAR__);
                    stan::math::fill(U_safe,DUMMY_VAR__);
                    current_statement_begin__ = 111;
                    local_scalar_t__ U_risky;
                    (void) U_risky;  // dummy to suppress unused var warning

                    stan::math::initialize(U_risky, DUMMY_VAR__);
                    stan::math::fill(U_risky,DUMMY_VAR__);


                    current_statement_begin__ = 113;
                    stan::math::assign(U_safe, ((get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2) * pow(get_base1(get_base1(safe_Hpayoff,i,"safe_Hpayoff",1),t,"safe_Hpayoff",2),get_base1(rho,i,"rho",1))) + ((1 - get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2)) * pow(get_base1(get_base1(safe_Lpayoff,i,"safe_Lpayoff",1),t,"safe_Lpayoff",2),get_base1(rho,i,"rho",1)))));
                    current_statement_begin__ = 114;
                    stan::math::assign(U_risky, ((get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2) * pow(get_base1(get_base1(risky_Hpayoff,i,"risky_Hpayoff",1),t,"risky_Hpayoff",2),get_base1(rho,i,"rho",1))) + ((1 - get_base1(get_base1(p_gamble,i,"p_gamble",1),t,"p_gamble",2)) * pow(get_base1(get_base1(risky_Lpayoff,i,"risky_Lpayoff",1),t,"risky_Lpayoff",2),get_base1(rho,i,"rho",1)))));
                    current_statement_begin__ = 115;
                    if (as_bool(logical_eq(get_base1(get_base1(condition,i,"condition",1),t,"condition",2),1))) {

                        current_statement_begin__ = 116;
                        stan::math::assign(U_safe, (U_safe + get_base1(ocu,i,"ocu",1)));
                    }
                    current_statement_begin__ = 118;
                    if (as_bool(logical_eq(get_base1(get_base1(condition,i,"condition",1),t,"condition",2),3))) {

                        current_statement_begin__ = 119;
                        stan::math::assign(U_risky, (U_risky + get_base1(ocu,i,"ocu",1)));
                    }
                    current_statement_begin__ = 121;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(tau,i,"tau",1) * (U_risky - U_safe)))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 123;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(inv_logit((get_base1(tau,i,"tau",1) * (U_risky - U_safe))), base_rng__), 
                                "assigning variable y_pred");
                    }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 82;
            check_greater_or_equal(function__,"mu_rho",mu_rho,0);
            check_less_or_equal(function__,"mu_rho",mu_rho,2);
            current_statement_begin__ = 83;
            check_greater_or_equal(function__,"mu_tau",mu_tau,0);
            current_statement_begin__ = 84;
            current_statement_begin__ = 87;
            current_statement_begin__ = 90;

            // write generated quantities
        vars__.push_back(mu_rho);
        vars__.push_back(mu_tau);
        vars__.push_back(mu_ocu);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_peer_ocu";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ocu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ocu" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ocu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ocu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ocu" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ocu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_peer_ocu_namespace::model_peer_ocu stan_model;


#endif
