/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_dd_cs_single_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_dd_cs_single");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_dd_cs_single");
    reader.add_event(77, 62, "end", "model_dd_cs_single");
    return reader;
}

#include <meta_header.hpp>
 class model_dd_cs_single : public prob_grad {
private:
    int Tsubj;
    vector<double> delay_later;
    vector<double> amount_later;
    vector<double> delay_sooner;
    vector<double> amount_sooner;
    vector<int> choice;
public:
    model_dd_cs_single(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_dd_cs_single(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_dd_cs_single_namespace::model_dd_cs_single";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec());
            Tsubj = int(0);
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            Tsubj = vals_i__[pos__++];
            current_statement_begin__ = 18;
            validate_non_negative_index("delay_later", "Tsubj", Tsubj);
            context__.validate_dims("data initialization", "delay_later", "double", context__.to_vec(Tsubj));
            validate_non_negative_index("delay_later", "Tsubj", Tsubj);
            delay_later = std::vector<double>(Tsubj,double(0));
            vals_r__ = context__.vals_r("delay_later");
            pos__ = 0;
            size_t delay_later_limit_0__ = Tsubj;
            for (size_t i_0__ = 0; i_0__ < delay_later_limit_0__; ++i_0__) {
                delay_later[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 19;
            validate_non_negative_index("amount_later", "Tsubj", Tsubj);
            context__.validate_dims("data initialization", "amount_later", "double", context__.to_vec(Tsubj));
            validate_non_negative_index("amount_later", "Tsubj", Tsubj);
            amount_later = std::vector<double>(Tsubj,double(0));
            vals_r__ = context__.vals_r("amount_later");
            pos__ = 0;
            size_t amount_later_limit_0__ = Tsubj;
            for (size_t i_0__ = 0; i_0__ < amount_later_limit_0__; ++i_0__) {
                amount_later[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("delay_sooner", "Tsubj", Tsubj);
            context__.validate_dims("data initialization", "delay_sooner", "double", context__.to_vec(Tsubj));
            validate_non_negative_index("delay_sooner", "Tsubj", Tsubj);
            delay_sooner = std::vector<double>(Tsubj,double(0));
            vals_r__ = context__.vals_r("delay_sooner");
            pos__ = 0;
            size_t delay_sooner_limit_0__ = Tsubj;
            for (size_t i_0__ = 0; i_0__ < delay_sooner_limit_0__; ++i_0__) {
                delay_sooner[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("amount_sooner", "Tsubj", Tsubj);
            context__.validate_dims("data initialization", "amount_sooner", "double", context__.to_vec(Tsubj));
            validate_non_negative_index("amount_sooner", "Tsubj", Tsubj);
            amount_sooner = std::vector<double>(Tsubj,double(0));
            vals_r__ = context__.vals_r("amount_sooner");
            pos__ = 0;
            size_t amount_sooner_limit_0__ = Tsubj;
            for (size_t i_0__ = 0; i_0__ < amount_sooner_limit_0__; ++i_0__) {
                amount_sooner[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("choice", "Tsubj", Tsubj);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(Tsubj));
            validate_non_negative_index("choice", "Tsubj", Tsubj);
            choice = std::vector<int>(Tsubj,int(0));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_0__ = Tsubj;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"Tsubj",Tsubj,1);
            current_statement_begin__ = 18;
            for (int k0__ = 0; k0__ < Tsubj; ++k0__) {
                check_greater_or_equal(function__,"delay_later[k0__]",delay_later[k0__],0);
            }
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < Tsubj; ++k0__) {
                check_greater_or_equal(function__,"amount_later[k0__]",amount_later[k0__],0);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < Tsubj; ++k0__) {
                check_greater_or_equal(function__,"delay_sooner[k0__]",delay_sooner[k0__],0);
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < Tsubj; ++k0__) {
                check_greater_or_equal(function__,"amount_sooner[k0__]",amount_sooner[k0__],0);
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < Tsubj; ++k0__) {
                check_greater_or_equal(function__,"choice[k0__]",choice[k0__],-(1));
                check_less_or_equal(function__,"choice[k0__]",choice[k0__],1);
            }
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 29;
            ++num_params_r__;
            current_statement_begin__ = 30;
            ++num_params_r__;
            current_statement_begin__ = 31;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_dd_cs_single() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("r")))
            throw std::runtime_error("variable r missing");
        vals_r__ = context__.vals_r("r");
        pos__ = 0U;
        context__.validate_dims("initialization", "r", "double", context__.to_vec());
        double r(0);
        r = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,r);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable r: ") + e.what());
        }

        if (!(context__.contains_r("s")))
            throw std::runtime_error("variable s missing");
        vals_r__ = context__.vals_r("s");
        pos__ = 0U;
        context__.validate_dims("initialization", "s", "double", context__.to_vec());
        double s(0);
        s = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,10,s);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable s: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,5,beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ r;
            (void) r;  // dummy to suppress unused var warning
            if (jacobian__)
                r = in__.scalar_lub_constrain(0,1,lp__);
            else
                r = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ s;
            (void) s;  // dummy to suppress unused var warning
            if (jacobian__)
                s = in__.scalar_lub_constrain(0,10,lp__);
            else
                s = in__.scalar_lub_constrain(0,10);

            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_lub_constrain(0,5,lp__);
            else
                beta = in__.scalar_lub_constrain(0,5);


            // transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("ev_later", "Tsubj", Tsubj);
            vector<local_scalar_t__> ev_later(Tsubj);
            stan::math::initialize(ev_later, DUMMY_VAR__);
            stan::math::fill(ev_later,DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("ev_sooner", "Tsubj", Tsubj);
            vector<local_scalar_t__> ev_sooner(Tsubj);
            stan::math::initialize(ev_sooner, DUMMY_VAR__);
            stan::math::fill(ev_sooner,DUMMY_VAR__);


            current_statement_begin__ = 38;
            for (int t = 1; t <= Tsubj; ++t) {

                current_statement_begin__ = 39;
                stan::model::assign(ev_later, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(amount_later,t,"amount_later",1) * stan::math::exp((-(1) * pow((r * get_base1(delay_later,t,"delay_later",1)),s)))), 
                            "assigning variable ev_later");
                current_statement_begin__ = 40;
                stan::model::assign(ev_sooner, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(amount_sooner,t,"amount_sooner",1) * stan::math::exp((-(1) * pow((r * get_base1(delay_sooner,t,"delay_sooner",1)),s)))), 
                            "assigning variable ev_sooner");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < Tsubj; ++i0__) {
                if (stan::math::is_uninitialized(ev_later[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ev_later" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < Tsubj; ++i0__) {
                if (stan::math::is_uninitialized(ev_sooner[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ev_sooner" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            current_statement_begin__ = 36;

            // model body

            current_statement_begin__ = 47;
            lp_accum__.add(uniform_log<propto__>(r, 0, 1));
            current_statement_begin__ = 48;
            lp_accum__.add(uniform_log<propto__>(s, 0, 10));
            current_statement_begin__ = 49;
            lp_accum__.add(uniform_log<propto__>(beta, 0, 5));
            current_statement_begin__ = 51;
            for (int t = 1; t <= Tsubj; ++t) {

                current_statement_begin__ = 52;
                lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(choice,t,"choice",1), (beta * (get_base1(ev_later,t,"ev_later",1) - get_base1(ev_sooner,t,"ev_sooner",1)))));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("r");
        names__.push_back("s");
        names__.push_back("beta");
        names__.push_back("ev_later");
        names__.push_back("ev_sooner");
        names__.push_back("logR");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Tsubj);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Tsubj);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Tsubj);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_dd_cs_single_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double r = in__.scalar_lub_constrain(0,1);
        double s = in__.scalar_lub_constrain(0,10);
        double beta = in__.scalar_lub_constrain(0,5);
        vars__.push_back(r);
        vars__.push_back(s);
        vars__.push_back(beta);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 35;
            validate_non_negative_index("ev_later", "Tsubj", Tsubj);
            vector<local_scalar_t__> ev_later(Tsubj);
            stan::math::initialize(ev_later, DUMMY_VAR__);
            stan::math::fill(ev_later,DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("ev_sooner", "Tsubj", Tsubj);
            vector<local_scalar_t__> ev_sooner(Tsubj);
            stan::math::initialize(ev_sooner, DUMMY_VAR__);
            stan::math::fill(ev_sooner,DUMMY_VAR__);


            current_statement_begin__ = 38;
            for (int t = 1; t <= Tsubj; ++t) {

                current_statement_begin__ = 39;
                stan::model::assign(ev_later, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(amount_later,t,"amount_later",1) * stan::math::exp((-(1) * pow((r * get_base1(delay_later,t,"delay_later",1)),s)))), 
                            "assigning variable ev_later");
                current_statement_begin__ = 40;
                stan::model::assign(ev_sooner, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(amount_sooner,t,"amount_sooner",1) * stan::math::exp((-(1) * pow((r * get_base1(delay_sooner,t,"delay_sooner",1)),s)))), 
                            "assigning variable ev_sooner");
            }

            // validate transformed parameters
            current_statement_begin__ = 35;
            current_statement_begin__ = 36;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < Tsubj; ++k_0__) {
            vars__.push_back(ev_later[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < Tsubj; ++k_0__) {
            vars__.push_back(ev_sooner[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 57;
            local_scalar_t__ logR;
            (void) logR;  // dummy to suppress unused var warning

            stan::math::initialize(logR, DUMMY_VAR__);
            stan::math::fill(logR,DUMMY_VAR__);
            current_statement_begin__ = 58;
            local_scalar_t__ log_lik;
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("y_pred", "Tsubj", Tsubj);
            vector<local_scalar_t__> y_pred(Tsubj);
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 63;
            stan::math::assign(logR, stan::math::log(r));

            current_statement_begin__ = 66;
            stan::math::assign(log_lik, 0);
            current_statement_begin__ = 68;
            for (int t = 1; t <= Tsubj; ++t) {

                current_statement_begin__ = 69;
                stan::math::assign(log_lik, (log_lik + bernoulli_logit_log(get_base1(choice,t,"choice",1),(beta * (get_base1(ev_later,t,"ev_later",1) - get_base1(ev_sooner,t,"ev_sooner",1))))));
                current_statement_begin__ = 72;
                stan::model::assign(y_pred, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            bernoulli_rng(inv_logit((beta * (get_base1(ev_later,t,"ev_later",1) - get_base1(ev_sooner,t,"ev_sooner",1)))), base_rng__), 
                            "assigning variable y_pred");
            }

            // validate generated quantities
            current_statement_begin__ = 57;
            current_statement_begin__ = 58;
            current_statement_begin__ = 61;

            // write generated quantities
        vars__.push_back(logR);
        vars__.push_back(log_lik);
            for (int k_0__ = 0; k_0__ < Tsubj; ++k_0__) {
            vars__.push_back(y_pred[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_dd_cs_single";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "s";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_later" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_sooner" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "logR";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "log_lik";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_pred" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "s";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_later" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_sooner" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "logR";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "log_lik";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Tsubj; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_pred" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}

typedef model_dd_cs_single_namespace::model_dd_cs_single stan_model;


#endif
