/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_bart_par4_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_bart_par4");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_bart_par4");
    reader.add_event(143, 128, "end", "model_bart_par4");
    return reader;
}

#include <meta_header.hpp>
 class model_bart_par4 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    int P;
    vector<vector<int> > pumps;
    vector<vector<int> > explosion;
    vector<vector<vector<int> > > d;
public:
    model_bart_par4(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_bart_par4(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_bart_par4_namespace::model_bart_par4";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            current_statement_begin__ = 21;
            validate_non_negative_index("pumps", "N", N);
            validate_non_negative_index("pumps", "T", T);
            context__.validate_dims("data initialization", "pumps", "int", context__.to_vec(N,T));
            validate_non_negative_index("pumps", "N", N);
            validate_non_negative_index("pumps", "T", T);
            pumps = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("pumps");
            pos__ = 0;
            size_t pumps_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < pumps_limit_1__; ++i_1__) {
                size_t pumps_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < pumps_limit_0__; ++i_0__) {
                    pumps[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("explosion", "N", N);
            validate_non_negative_index("explosion", "T", T);
            context__.validate_dims("data initialization", "explosion", "int", context__.to_vec(N,T));
            validate_non_negative_index("explosion", "N", N);
            validate_non_negative_index("explosion", "T", T);
            explosion = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("explosion");
            pos__ = 0;
            size_t explosion_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < explosion_limit_1__; ++i_1__) {
                size_t explosion_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < explosion_limit_0__; ++i_0__) {
                    explosion[i_0__][i_1__] = vals_i__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],0);
            }
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"P",P,2);
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"pumps[k0__][k1__]",pumps[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"explosion[k0__][k1__]",explosion[k0__][k1__],0);
                    check_less_or_equal(function__,"explosion[k0__][k1__]",explosion[k0__][k1__],1);
                }
            }
            // initialize data variables
            current_statement_begin__ = 27;
            validate_non_negative_index("d", "N", N);
            validate_non_negative_index("d", "T", T);
            validate_non_negative_index("d", "P", P);
            d = std::vector<std::vector<std::vector<int> > >(N,std::vector<std::vector<int> >(T,std::vector<int>(P,int(0))));
            stan::math::fill(d, std::numeric_limits<int>::min());

            current_statement_begin__ = 29;
            for (int j = 1; j <= N; ++j) {

                current_statement_begin__ = 30;
                for (int k = 1; k <= get_base1(Tsubj,j,"Tsubj",1); ++k) {

                    current_statement_begin__ = 31;
                    for (int l = 1; l <= P; ++l) {

                        current_statement_begin__ = 32;
                        if (as_bool(logical_lte(l,get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2)))) {
                            current_statement_begin__ = 33;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list()))), 
                                        1, 
                                        "assigning variable d");
                        } else {
                            current_statement_begin__ = 35;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list()))), 
                                        0, 
                                        "assigning variable d");
                        }
                    }
                }
            }

            // validate transformed data
            current_statement_begin__ = 27;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 43;
            validate_non_negative_index("mu_pr", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 44;
            validate_non_negative_index("sigma", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 47;
            validate_non_negative_index("phi_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 48;
            validate_non_negative_index("eta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 49;
            validate_non_negative_index("gam_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 50;
            validate_non_negative_index("tau_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_bart_par4() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "4", 4);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(4));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "4", 4);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("phi_pr")))
            throw std::runtime_error("variable phi_pr missing");
        vals_r__ = context__.vals_r("phi_pr");
        pos__ = 0U;
        validate_non_negative_index("phi_pr", "N", N);
        context__.validate_dims("initialization", "phi_pr", "vector_d", context__.to_vec(N));
        vector_d phi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            phi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(phi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi_pr: ") + e.what());
        }

        if (!(context__.contains_r("eta_pr")))
            throw std::runtime_error("variable eta_pr missing");
        vals_r__ = context__.vals_r("eta_pr");
        pos__ = 0U;
        validate_non_negative_index("eta_pr", "N", N);
        context__.validate_dims("initialization", "eta_pr", "vector_d", context__.to_vec(N));
        vector_d eta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            eta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(eta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable eta_pr: ") + e.what());
        }

        if (!(context__.contains_r("gam_pr")))
            throw std::runtime_error("variable gam_pr missing");
        vals_r__ = context__.vals_r("gam_pr");
        pos__ = 0U;
        validate_non_negative_index("gam_pr", "N", N);
        context__.validate_dims("initialization", "gam_pr", "vector_d", context__.to_vec(N));
        vector_d gam_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            gam_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(gam_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gam_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        validate_non_negative_index("tau_pr", "N", N);
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(4,lp__);
            else
                mu_pr = in__.vector_constrain(4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,4,lp__);
            else
                sigma = in__.vector_lb_constrain(0,4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  phi_pr;
            (void) phi_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                phi_pr = in__.vector_constrain(N,lp__);
            else
                phi_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta_pr;
            (void) eta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_pr = in__.vector_constrain(N,lp__);
            else
                eta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam_pr;
            (void) gam_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                gam_pr = in__.vector_constrain(N,lp__);
            else
                gam_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau_pr;
            (void) tau_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_pr = in__.vector_constrain(N,lp__);
            else
                tau_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 55;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(N));
            (void) phi;  // dummy to suppress unused var warning

            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi,DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
            (void) eta;  // dummy to suppress unused var warning

            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta,DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("gam", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam(static_cast<Eigen::VectorXd::Index>(N));
            (void) gam;  // dummy to suppress unused var warning

            stan::math::initialize(gam, DUMMY_VAR__);
            stan::math::fill(gam,DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 60;
            stan::math::assign(phi, Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),phi_pr))));
            current_statement_begin__ = 61;
            stan::math::assign(eta, stan::math::exp(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),eta_pr))));
            current_statement_begin__ = 62;
            stan::math::assign(gam, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),gam_pr))));
            current_statement_begin__ = 63;
            stan::math::assign(tau, stan::math::exp(add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),tau_pr))));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(phi(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(eta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(gam(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gam" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(tau(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 55;
            check_greater_or_equal(function__,"phi",phi,0);
            check_less_or_equal(function__,"phi",phi,1);
            current_statement_begin__ = 56;
            check_greater_or_equal(function__,"eta",eta,0);
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"gam",gam,0);
            current_statement_begin__ = 58;
            check_greater_or_equal(function__,"tau",tau,0);

            // model body

            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(phi_pr, 0, 1));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(eta_pr, 0, 1));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log<propto__>(gam_pr, 0, 1));
            current_statement_begin__ = 74;
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1));
            current_statement_begin__ = 77;
            for (int j = 1; j <= N; ++j) {
                {
                current_statement_begin__ = 79;
                int n_succ(0);
                (void) n_succ;  // dummy to suppress unused var warning

                stan::math::fill(n_succ, std::numeric_limits<int>::min());
                stan::math::assign(n_succ,0);
                current_statement_begin__ = 80;
                int n_pump(0);
                (void) n_pump;  // dummy to suppress unused var warning

                stan::math::fill(n_pump, std::numeric_limits<int>::min());
                stan::math::assign(n_pump,0);


                current_statement_begin__ = 82;
                for (int k = 1; k <= get_base1(Tsubj,j,"Tsubj",1); ++k) {
                    {
                    current_statement_begin__ = 83;
                    local_scalar_t__ p_burst;
                    (void) p_burst;  // dummy to suppress unused var warning

                    stan::math::initialize(p_burst, DUMMY_VAR__);
                    stan::math::fill(p_burst,DUMMY_VAR__);
                    current_statement_begin__ = 84;
                    local_scalar_t__ omega;
                    (void) omega;  // dummy to suppress unused var warning

                    stan::math::initialize(omega, DUMMY_VAR__);
                    stan::math::fill(omega,DUMMY_VAR__);


                    current_statement_begin__ = 86;
                    stan::math::assign(p_burst, (1 - ((get_base1(phi,j,"phi",1) + (get_base1(eta,j,"eta",1) * n_succ)) / (1 + (get_base1(eta,j,"eta",1) * n_pump)))));
                    current_statement_begin__ = 87;
                    stan::math::assign(omega, (-(get_base1(gam,j,"gam",1)) / log1m(p_burst)));
                    current_statement_begin__ = 90;
                    for (int l = 1; l <= ((get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2) + 1) - get_base1(get_base1(explosion,j,"explosion",1),k,"explosion",2)); ++l) {
                        current_statement_begin__ = 91;
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(get_base1(d,j,"d",1),k,"d",2),l,"d",3), (get_base1(tau,j,"tau",1) * (omega - l))));
                    }
                    current_statement_begin__ = 94;
                    stan::math::assign(n_succ, (n_succ + (get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2) - get_base1(get_base1(explosion,j,"explosion",1),k,"explosion",2))));
                    current_statement_begin__ = 95;
                    stan::math::assign(n_pump, (n_pump + get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2)));
                    }
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("phi_pr");
        names__.push_back("eta_pr");
        names__.push_back("gam_pr");
        names__.push_back("tau_pr");
        names__.push_back("phi");
        names__.push_back("eta");
        names__.push_back("gam");
        names__.push_back("tau");
        names__.push_back("mu_phi");
        names__.push_back("mu_eta");
        names__.push_back("mu_gam");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dims__.push_back(P);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_bart_par4_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d phi_pr = in__.vector_constrain(N);
        vector_d eta_pr = in__.vector_constrain(N);
        vector_d gam_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(phi_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gam_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 55;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(N));
            (void) phi;  // dummy to suppress unused var warning

            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi,DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
            (void) eta;  // dummy to suppress unused var warning

            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta,DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("gam", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam(static_cast<Eigen::VectorXd::Index>(N));
            (void) gam;  // dummy to suppress unused var warning

            stan::math::initialize(gam, DUMMY_VAR__);
            stan::math::fill(gam,DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 60;
            stan::math::assign(phi, Phi_approx(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),phi_pr))));
            current_statement_begin__ = 61;
            stan::math::assign(eta, stan::math::exp(add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),eta_pr))));
            current_statement_begin__ = 62;
            stan::math::assign(gam, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),gam_pr))));
            current_statement_begin__ = 63;
            stan::math::assign(tau, stan::math::exp(add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),tau_pr))));

            // validate transformed parameters
            current_statement_begin__ = 55;
            check_greater_or_equal(function__,"phi",phi,0);
            check_less_or_equal(function__,"phi",phi,1);
            current_statement_begin__ = 56;
            check_greater_or_equal(function__,"eta",eta,0);
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"gam",gam,0);
            current_statement_begin__ = 58;
            check_greater_or_equal(function__,"tau",tau,0);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(phi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gam[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 102;
            local_scalar_t__ mu_phi;
            (void) mu_phi;  // dummy to suppress unused var warning

            stan::math::initialize(mu_phi, DUMMY_VAR__);
            stan::math::fill(mu_phi,DUMMY_VAR__);
            stan::math::assign(mu_phi,Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 103;
            local_scalar_t__ mu_eta;
            (void) mu_eta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_eta, DUMMY_VAR__);
            stan::math::fill(mu_eta,DUMMY_VAR__);
            stan::math::assign(mu_eta,stan::math::exp(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 104;
            local_scalar_t__ mu_gam;
            (void) mu_gam;  // dummy to suppress unused var warning

            stan::math::initialize(mu_gam, DUMMY_VAR__);
            stan::math::fill(mu_gam,DUMMY_VAR__);
            stan::math::assign(mu_gam,stan::math::exp(get_base1(mu_pr,3,"mu_pr",1)));
            current_statement_begin__ = 105;
            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning

            stan::math::initialize(mu_tau, DUMMY_VAR__);
            stan::math::fill(mu_tau,DUMMY_VAR__);
            stan::math::assign(mu_tau,stan::math::exp(get_base1(mu_pr,4,"mu_pr",1)));
            current_statement_begin__ = 108;
            local_scalar_t__ log_lik;
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            stan::math::assign(log_lik,0);
            current_statement_begin__ = 111;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            validate_non_negative_index("y_pred", "P", P);
            vector<vector<vector<local_scalar_t__> > > y_pred(N, (vector<vector<local_scalar_t__> >(T, (vector<local_scalar_t__>(P)))));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 114;
            for (int j = 1; j <= N; ++j) {
                current_statement_begin__ = 115;
                for (int k = 1; k <= T; ++k) {
                    current_statement_begin__ = 116;
                    for (int l = 1; l <= P; ++l) {
                        current_statement_begin__ = 117;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list()))), 
                                    -(1), 
                                    "assigning variable y_pred");
                    }
                }
            }

            current_statement_begin__ = 120;
            for (int j = 1; j <= N; ++j) {
                {
                current_statement_begin__ = 121;
                int n_succ(0);
                (void) n_succ;  // dummy to suppress unused var warning

                stan::math::fill(n_succ, std::numeric_limits<int>::min());
                stan::math::assign(n_succ,0);
                current_statement_begin__ = 122;
                int n_pump(0);
                (void) n_pump;  // dummy to suppress unused var warning

                stan::math::fill(n_pump, std::numeric_limits<int>::min());
                stan::math::assign(n_pump,0);


                current_statement_begin__ = 124;
                for (int k = 1; k <= get_base1(Tsubj,j,"Tsubj",1); ++k) {
                    {
                    current_statement_begin__ = 125;
                    local_scalar_t__ p_burst;
                    (void) p_burst;  // dummy to suppress unused var warning

                    stan::math::initialize(p_burst, DUMMY_VAR__);
                    stan::math::fill(p_burst,DUMMY_VAR__);
                    current_statement_begin__ = 126;
                    local_scalar_t__ omega;
                    (void) omega;  // dummy to suppress unused var warning

                    stan::math::initialize(omega, DUMMY_VAR__);
                    stan::math::fill(omega,DUMMY_VAR__);


                    current_statement_begin__ = 128;
                    stan::math::assign(p_burst, (1 - ((get_base1(phi,j,"phi",1) + (get_base1(eta,j,"eta",1) * n_succ)) / (1 + (get_base1(eta,j,"eta",1) * n_pump)))));
                    current_statement_begin__ = 129;
                    stan::math::assign(omega, (-(get_base1(gam,j,"gam",1)) / log1m(p_burst)));
                    current_statement_begin__ = 131;
                    for (int l = 1; l <= ((get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2) + 1) - get_base1(get_base1(explosion,j,"explosion",1),k,"explosion",2)); ++l) {

                        current_statement_begin__ = 132;
                        stan::math::assign(log_lik, (log_lik + bernoulli_logit_log(get_base1(get_base1(get_base1(d,j,"d",1),k,"d",2),l,"d",3),(get_base1(tau,j,"tau",1) * (omega - l)))));
                        current_statement_begin__ = 133;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(l), stan::model::nil_index_list()))), 
                                    bernoulli_logit_rng((get_base1(tau,j,"tau",1) * (omega - l)), base_rng__), 
                                    "assigning variable y_pred");
                    }
                    current_statement_begin__ = 136;
                    stan::math::assign(n_succ, (n_succ + (get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2) - get_base1(get_base1(explosion,j,"explosion",1),k,"explosion",2))));
                    current_statement_begin__ = 137;
                    stan::math::assign(n_pump, (n_pump + get_base1(get_base1(pumps,j,"pumps",1),k,"pumps",2)));
                    }
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 102;
            check_greater_or_equal(function__,"mu_phi",mu_phi,0);
            check_less_or_equal(function__,"mu_phi",mu_phi,1);
            current_statement_begin__ = 103;
            check_greater_or_equal(function__,"mu_eta",mu_eta,0);
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"mu_gam",mu_gam,0);
            current_statement_begin__ = 105;
            check_greater_or_equal(function__,"mu_tau",mu_tau,0);
            current_statement_begin__ = 108;
            current_statement_begin__ = 111;

            // write generated quantities
        vars__.push_back(mu_phi);
        vars__.push_back(mu_eta);
        vars__.push_back(mu_gam);
        vars__.push_back(mu_tau);
        vars__.push_back(log_lik);
            for (int k_2__ = 0; k_2__ < P; ++k_2__) {
                for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                    for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                    vars__.push_back(y_pred[k_0__][k_1__][k_2__]);
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bart_par4";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gam_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gam" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gam";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "log_lik";
        param_names__.push_back(param_name_stream__.str());
        for (int k_2__ = 1; k_2__ <= P; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gam_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gam" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gam";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "log_lik";
        param_names__.push_back(param_name_stream__.str());
        for (int k_2__ = 1; k_2__ <= P; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
    }

}; // model

}

typedef model_bart_par4_namespace::model_bart_par4 stan_model;


#endif
