% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.performance}
\alias{h2o.performance}
\title{Model Performance Metrics in H2O}
\usage{
h2o.performance(model, data = NULL, valid = FALSE, ...)
}
\arguments{
\item{model}{An \linkS4class{H2OModel} object}

\item{data}{An H2O Frame. The model will make predictions
on this dataset, and subsequently score them. The dataset should
match the dataset that was used to train the model, in terms of
column names, types, and dimensions. If data is passed in, then train and valid are ignored.}

\item{valid}{A logical value indicating whether to return the validation metrics (constructed during training).}

\item{...}{Extra args passed in for use by other functions.}
}
\value{
Returns an object of the \linkS4class{H2OModelMetrics} subclass.
}
\description{
Given a trained h2o model, compute its performance on the given
dataset
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
prostate.hex$CAPSULE <- as.factor(prostate.hex$CAPSULE)
prostate.gbm <- h2o.gbm(3:9, "CAPSULE", prostate.hex)
h2o.performance(model = prostate.gbm, data=prostate.hex)
}
}

