% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.gainsLift}
\alias{h2o.gainsLift}
\alias{h2o.gains_lift}
\alias{h2o.gainsLift,H2OModel-method}
\alias{h2o.gainsLift,H2OModelMetrics-method}
\title{Access H2O Gains/Lift Tables}
\usage{
h2o.gainsLift(object, ...)

h2o.gains_lift(object, ...)

\S4method{h2o.gainsLift}{H2OModel}(object, newdata, valid = FALSE, xval = FALSE, ...)

\S4method{h2o.gainsLift}{H2OModelMetrics}(object)
}
\arguments{
\item{object}{Either an \linkS4class{H2OModel} object or an
\linkS4class{H2OModelMetrics} object.}

\item{\dots}{further arguments to be passed to/from this method.}

\item{newdata}{An H2OFrame object that can be scored on.
Requires a valid response column.}

\item{valid}{Retrieve the validation metric.}

\item{xval}{Retrieve the cross-validation metric.}
}
\value{
Calling this function on \linkS4class{H2OModel} objects returns a
        Gains/Lift table corresponding to the \code{\link{predict}} function.
}
\description{
Retrieve either a single or many Gains/Lift tables from H2O objects.
}
\details{
The \linkS4class{H2OModelMetrics} version of this function will only take
\linkS4class{H2OBinomialMetrics} objects.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(prostate_path)
prostate[, 2] <- as.factor(prostate[, 2])
model <- h2o.gbm(x = 3:9, y = 2, distribution = "bernoulli",
                 training_frame = prostate, validation_frame = prostate, nfolds = 3)
h2o.gainsLift(model)              ## extract training metrics
h2o.gainsLift(model, valid = TRUE)  ## extract validation metrics (here: the same)
h2o.gainsLift(model, xval = TRUE)  ## extract cross-validation metrics
h2o.gainsLift(model, newdata = prostate) ## score on new data (here: the same)
# Generating a ModelMetrics object
perf <- h2o.performance(model, prostate)
h2o.gainsLift(perf)               ## extract from existing metrics object
}
}
\seealso{
\code{\link{predict}} for generating prediction frames,
         \code{\link{h2o.performance}} for creating
         \linkS4class{H2OModelMetrics}.
}
