% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{h2o.decryptionSetup}
\alias{h2o.decryptionSetup}
\title{Setup a Decryption Tool}
\usage{
h2o.decryptionSetup(
  keystore,
  keystore_type = "JCEKS",
  key_alias = NA_character_,
  password = NA_character_,
  decrypt_tool = "",
  decrypt_impl = "water.parser.GenericDecryptionTool",
  cipher_spec = NA_character_
)
}
\arguments{
\item{keystore}{An H2OFrame object referencing a loaded Java Keystore (see example).}

\item{keystore_type}{(Optional) Specification of Keystore type, defaults to JCEKS.}

\item{key_alias}{Which key from the keystore to use for decryption.}

\item{password}{Password to the keystore and the key.}

\item{decrypt_tool}{(Optional) Name of the decryption tool.}

\item{decrypt_impl}{(Optional) Java class name implementing the Decryption Tool.}

\item{cipher_spec}{Specification of a cipher (eg.: AES/ECB/PKCS5Padding).}
}
\description{
If your source file is encrypted - setup a Decryption Tool and then provide
the reference (result of this function) to the import functions.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
ks_path <- system.file("extdata", "keystore.jks", package = "h2o")
keystore <- h2o.importFile(path = ks_path, parse = FALSE) # don't parse, keep as a binary file
cipher <- "AES/ECB/PKCS5Padding"
pwd <- "Password123"
alias <- "secretKeyAlias"
dt <- h2o.decryptionSetup(keystore, key_alias = alias, password = pwd, cipher_spec = cipher)
data_path <- system.file("extdata", "prostate.csv.aes", package = "h2o")
data <- h2o.importFile(data_path, decrypt_tool = dt)
summary(data)
}
}
\seealso{
\link{h2o.importFile}, \link{h2o.parseSetup}
}
