% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.kfold_column}
\alias{h2o.kfold_column}
\title{Produce a k-fold column vector.}
\usage{
h2o.kfold_column(data, nfolds, seed = -1)
}
\arguments{
\item{data}{A dataframe against which to create the fold column.}

\item{nfolds}{The number of desired folds.}

\item{seed}{A random seed, -1 indicates that H2O will choose one.}
}
\value{
Returns an H2OFrame object with fold assignments.
}
\description{
Create a k-fold vector useful for H2O algorithms that take a fold_assignments argument.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/iris/iris_wheader.csv"
iris <- h2o.importFile(f)
kfolds <- h2o.kfold_column(iris, nfolds = 5, seed = 1234)
}
}
