% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{h2o.startLogging}
\alias{h2o.startLogging}
\title{Start Writing H2O R Logs}
\usage{
h2o.startLogging(file)
}
\arguments{
\item{file}{a character string name for the file, automatically generated}
}
\description{
Begin logging H2o R POST commands and error responses to local disk. Used
primarily for debuggin purposes.
}
\examples{
\donttest{
library(h2o)
h2o.init()
h2o.startLogging()
australia_path = system.file("extdata", "australia.csv", package = "h2o")
australia = h2o.importFile(path = australia_path)
h2o.stopLogging()
}
}
\seealso{
\code{\link{h2o.stopLogging}, \link{h2o.clearLog},
         \link{h2o.openLog}}
}
