% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aggregator.R
\name{h2o.aggregator}
\alias{h2o.aggregator}
\title{Builds an Aggregated Frame of an H2OFrame}
\usage{
h2o.aggregator(training_frame, x, model_id = NULL, ignore_const_cols = TRUE,
  target_num_exemplars = 5000, rel_tol_num_exemplars = 0.5,
  transform = c("NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE"),
  categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
  "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited"))
}
\arguments{
\item{training_frame}{Id of the training data frame.}

\item{x}{A vector containing the \code{character} names of the predictors in the model.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{target_num_exemplars}{Targeted number of exemplars Defaults to 5000.}

\item{rel_tol_num_exemplars}{Relative tolerance for number of exemplars (e.g, 0.5 is +/- 50 percents) Defaults to 0.5.}

\item{transform}{Transformation of training data Must be one of: "NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE".
Defaults to NORMALIZE.}

\item{categorical_encoding}{Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
"Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.}
}
\description{
Builds an Aggregated Frame of an H2OFrame
}

