% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{H2ORawData-class}
\alias{H2ORawData}
\alias{H2ORawData-class}
\alias{show,H2ORawData-method}
\title{The H2ORawData class.}
\usage{
\S4method{show}{H2ORawData}(object)
}
\arguments{
\item{object}{a \code{H2ORawData} object.}
}
\description{
This class represents data in a post-import format.
}
\details{
Data ingestion is a two-step process in H2O. First, a given path to a data source is _imported_ for validation by the
user. The user may continue onto _parsing_ all of the data into memory, or the user may choose to back out and make
corrections. Imported data is in a staging area such that H2O is aware of the data, but the data is not yet in
memory.

The H2ORawData is a representation of the imported, not yet parsed, data.
}
\section{Slots}{

\describe{
\item{\code{conn}}{An \code{H2OConnection} object containing the IP address and port number of the H2O server.}

\item{\code{frame_id}}{An object of class \code{"character"}, which is the name of the key assigned to the imported data.}

\item{\code{finalizers}}{A \code{list} object containing environments with finalizers that
remove objects from the H2O cloud.}
}}

