% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.prcomp}
\alias{h2o.prcomp}
\title{Principal Components Analysis}
\usage{
h2o.prcomp(training_frame, x, k, model_id, max_iterations = 1000,
  transform = "NONE", seed, use_all_factor_levels)
}
\arguments{
\item{training_frame}{An \linkS4class{H2OFrame} object containing the
variables in the model.}

\item{x}{(Optional) A vector containing the data columns on which SVD operates.}

\item{k}{The number of principal components to be computed. This must be
between 1 and min(ncol(training_frame), nrow(training_frame)) inclusive.}

\item{model_id}{(Optional) The unique hex key assigned to the
resulting model. Automatically generated if none is provided.}

\item{max_iterations}{The maximum number of iterations to run each power
iteration loop. Must be between 1 and 1e6 inclusive.}

\item{transform}{A character string that indicates how the training data
should be transformed before running PCA. Possible values are "NONE":
for no transformation, "DEMEAN": for subtracting the mean of each
column, "DESCALE": for dividing by the standard deviation of each
column, "STANDARDIZE": for demeaning and descaling, and "NORMALIZE":
for demeaning and dividing each column by its range (max - min).}

\item{seed}{(Optional) Random seed used to initialize the right singular vectors
at the beginning of each power method iteration.}

\item{use_all_factor_levels}{(Optional) A logical value indicating whether all
factor levels should be included in each categorical column expansion.
If FALSE, the indicator column corresponding to the first factor level
of every categorical variable will be dropped. Defaults to FALSE.}
}
\value{
Returns an object of class \linkS4class{H2ODimReductionModel}.
}
\description{
Principal components analysis of a H2O dataset using the power method
to calculate the singular value decomposition of the Gram matrix.
}
\examples{
library(h2o)
localH2O <- h2o.init()
ausPath <- system.file("extdata", "australia.csv", package="h2o")
australia.hex <- h2o.uploadFile(localH2O, path = ausPath)
h2o.prcomp(training_frame = australia.hex, k = 8, transform = "STANDARDIZE")
}

