% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nldi.R
\name{get_nldi_interactively}
\alias{get_nldi_interactively}
\title{Get NLDI Interactively}
\usage{
get_nldi_interactively()
}
\value{
A list with sf objects.
}
\description{
This function uses the NLDI API to allow the user to visually
select a location (point) to get numerous hydrologic realizations.
}
\note{
The picker list has three options right now: Total Basin, All Local Catchments and Only Local Catchment.
Descriptions below:
\itemize{
\item  \strong{Total Basin}: This will return the upstream tributaries (UT), upstream main (UM),
basin boundary and site data above the user point.
\item  \strong{All Local Catchments}: This will return the upstream tributaries (UT) and all the
local NHDPLusV2 catchments above the user point. In addition, each catchment will contain the
zonal stats associated with 'CAT' in NLDI.
\item \strong{Only Local Catchment}: This will only return the catchment at the point and tributary.
In addition, it will also include the zonal stat for that catchment.
}
}
\examples{

if(interactive()){
nldi_data <- get_nldi_interactively()
}
}
