% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plot.R
\name{pca_plot}
\alias{pca_plot}
\title{PCA Plot}
\usage{
pca_plot(
  data,
  xComponent = "PC1",
  yComponent = "PC2",
  legendPos = "right",
  soft = "PLINK",
  colPalette = "Accent",
  title = NULL
)
}
\arguments{
\item{data}{PLINK pca or EIGENSTRAT smartpca output,
(or any tab-delimited file or data.frame with the same format as PLINK pca or EIGENSTRAT smartpca output)}

\item{xComponent}{A character vector indicating the principal component value to use for the x-axis.
Default is "PC1"}

\item{yComponent}{A character vector indicating the principal component value to use for the x-axis.
Default is "PC2"}

\item{legendPos}{A character vector indicating the legend position. Default is "right".}

\item{soft}{A character vector indicating the software output format. Default is "PLINK".
If you have a tab-delimited file or data.frame with the same format as EIGENSTRAT output, use "EIGENSTRAT"}

\item{colPalette}{A character vector indicating the color palette to use. Default is "Accent".}

\item{title}{A string denoting the title to use for the plot. Default is 'PCA Plot'}
}
\value{
A PCA plot.
}
\description{
Creates a PCA plot
}
\details{
Creates a PCA plot from PLINK pca output, EIGENSTRAT smartpca,
(or any tab-delimited file or data.frame with the same format as PLINK pca or EIGENSTRAT smartpca output).
}
\examples{
pca_plot(pcaData)

}
\author{
Lindokuhle Nkambule
}
