\name{plot.gvlma}
\alias{plot.gvlma}

\title{Various Plots for a Gvlma Object}
\description{
Diagnostic plots for a single-response gvlma linear model.
}
\usage{
\method{plot}{gvlma}(x, onepage = TRUE, ask = !onepage && prod(par("mfcol")) <
    ncol(model.matrix(x)) + 4 && dev.interactive(), \dots)
}

\arguments{
  \item{x}{A \code{gvlmaobj} object. }
  \item{onepage}{If TRUE, all plots will be displayed in one page of
    graphs.}
  \item{ask}{If TRUE, user will be prompted before plots begin a new
    page.}
  \item{\dots}{Additional arguments that are ignored.}
}
\details{
A series of plots is generated for diagnostic assessment of a linear
model for a single response variable.  The plots are similar to those
generated by \code{plot.lm}.  The
plots are (a) the response versus each of the predictors in the model,
(b) the response versus the time sequence in the gvlma object
(\code{gvlmaobj\$GlobalTest\$timeseq}), which is the time sequence used for
computing the directional test statistic \eqn{S^2_4}, (c) the
standardized
residuals vs the fitted values, (d) a histogram of the standardized
residuals, (e) a normal probability plot of the standardized residuals,
and (f) a plot of the standardized residuals versus the time sequence.

Note that the standardized residuals here are computed as the raw
residuals divided by the MLE of the error standard deviation
(i.e. sqrt(SSE/n)).
}
\value{
  No value is returned.
}
\references{Pena, EA and Slate, EH (2006).  \dQuote{Global validation of
  linear model assumptions,} \emph{J.\ Amer.\ Statist.\ Assoc.},
  \bold{101}(473):341-354.}
\author{Slate, EH \email{slate@stat.fsu.edu} and Pena, EA
  \email{pena@stat.sc.edu}. }
\note{
The standardized residuals here are computed as the raw
residuals divided by the MLE of the error standard deviation
(i.e. sqrt(SSE/n)).
}
\seealso{\code{\link{gvlma}}}
\examples{
data(CarMileageData)
CarModelAssess <- gvlma(NumGallons ~ MilesLastFill + NumDaysBetw,
    data = CarMileageData)
plot(CarModelAssess)
par(mfrow=c(2,2))
plot(CarModelAssess, onepage = FALSE)
}
\keyword{graphs}% at least one, from doc/KEYWORDS

