% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guf.R
\name{left}
\alias{left}
\title{Get the specified left most characters of a string}
\usage{
left(string, nr_of_chars)
}
\arguments{
\item{string}{A character string, or a vector of character strings. This is the (vector of) character strings(s) of which the starting characters are to be returned.}

\item{nr_of_chars}{An integer or a vector of integers, specifying the number of characters from the start of the string to return. If both 'string' and 'nr_or_chars' are a vector, then the vector lengths must match.}
}
\value{
A character string, or a vector of character strings if the input is a vector.
}
\description{
left() counts from the start of a character string, for a specified number of characters, and returns the resulting substring. If the specified number of characters is more than the total length of the string, then the entire string will be returned.
}
\examples{
left("hello world", 2) # returns 'he'
left(c("hello", "world"), 2) # returns vector c('he', 'wo')
left(c("hello", "world"), c(1,3)) # returns vector c('h', 'wor')
left("hello world", 80) # returns 'hello world'
}
