% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nevent.R
\name{add_nevent.tbl_uvregression}
\alias{add_nevent.tbl_uvregression}
\title{Add number of events to a regression table}
\usage{
\method{add_nevent}{tbl_uvregression}(x, ...)
}
\arguments{
\item{x}{\code{tbl_uvregerssion} object}

\item{...}{Not used}
}
\value{
A \code{tbl_uvregression} object
}
\description{
Adds a column of the number of events to tables created with
\link{tbl_uvregression}.  Supported
model types include GLMs with binomial distribution family (e.g.
\link[stats:glm]{stats::glm}, \link[lme4:glmer]{lme4::glmer}, and
\link[geepack:geeglm]{geepack::geeglm}) and Cox
Proportion Hazards regression models (\link[survival:coxph]{survival::coxph}).
}
\section{Reporting Event N}{

The number of events is added to the internal \code{.$table_body} tibble,
and printed to the right of the N column. The number of events is also
accessible via the \link{inline_text} function for printing in a report.
}

\section{Example Output}{

\if{html}{\figure{tbl_uv_nevent_ex.png}{options: width=50\%}}
}

\examples{
tbl_uv_nevent_ex <-
  trial[c("response", "trt", "age", "grade")] \%>\%
  tbl_uvregression(
    method = glm,
    y = response,
    method.args = list(family = binomial)
  ) \%>\%
  add_nevent()
}
\seealso{
Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_q.tbl_uvregression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_stack}()},
\code{\link{bold_p.tbl_uvregression}()},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_uvregression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
