% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibbleS3}
\alias{as_tibbleS3}
\alias{as_tibble.tbl_summary}
\alias{as_tibble.tbl_regression}
\alias{as_tibble.tbl_uvregression}
\alias{as_tibble.tbl_merge}
\alias{as_tibble.tbl_stack}
\alias{as_tibble.tbl_survival}
\title{Convert gtsummary object to tibble}
\usage{
\method{as_tibble}{tbl_summary}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)

\method{as_tibble}{tbl_regression}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)

\method{as_tibble}{tbl_uvregression}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)

\method{as_tibble}{tbl_merge}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)

\method{as_tibble}{tbl_stack}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)

\method{as_tibble}{tbl_survival}(x, include = NULL, exclude = NULL, col_labels = TRUE, ...)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Character vector naming kable commands to include in printing.
Default is \code{NULL}, which utilizes all commands in \code{x$kable_calls}.}

\item{exclude}{Character vector naming kable commands to exclude in printing.
Default is \code{NULL}.}

\item{col_labels}{Logical argument adding column labels to output tibble.
Default is \code{TRUE}.}

\item{...}{Not used}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Function converts gtsummary objects tibbles. The formatting stored in
\code{x$kable_calls} is applied.
}
\examples{
tbl <-
  trial \%>\%
  tbl_summary(by = trt)

as_tibble(tbl)

# without column labels
as_tibble(tbl, col_names = FALSE)
}
\seealso{
\link{tbl_summary} \link{tbl_regression} \link{tbl_uvregression} \link{tbl_survival}
}
\author{
Daniel D. Sjoberg
}
