% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtfs_methods.R
\name{print.gtfs}
\alias{print.gtfs}
\title{Print a GTFS object}
\usage{
\method{print}{gtfs}(x, ...)
}
\arguments{
\item{x}{A GTFS object.}

\item{...}{Optional arguments ultimately passed to \code{format}.}
}
\value{
The GTFS object that was printed, invisibly.
}
\description{
Prints a GTFS object suppressing the \code{class} attribute.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

# subset 'gtfs' for a smaller output
gtfs <- gtfs[c("routes", "trips")]

print(gtfs)

}
