% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_duplicate_column.R
\name{gt_duplicate_column}
\alias{gt_duplicate_column}
\title{Duplicate an existing column in a gt table}
\usage{
gt_duplicate_column(
  gt_object,
  column,
  after = dplyr::last_col(),
  append_text = "_dupe",
  dupe_name = NULL
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column to be duplicated}

\item{after}{The column to place the duplicate column after}

\item{append_text}{The text to add to the column name to differentiate it from the original column name}

\item{dupe_name}{A full name for the "new" duplicated column, will override \code{append_text}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
This function takes an existing gt table and will duplicate a column.
You also have the option to specify where the column ends up, and what will
be appending to the end of the column name to differentiate it.
}
\section{Function ID}{

2-15
}

\examples{
library(gt)
dupe_table <- head(mtcars) \%>\%
  dplyr::select(mpg, disp) \%>\%
  gt() \%>\%
  gt_duplicate_column(mpg, after = disp, append_text = "2")

}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
