% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{metro}
\alias{metro}
\title{The stations of the Paris Metro}
\format{
A tibble with 314 rows and 11 variables:
\describe{
\item{name}{The name of the station.}
\item{caption}{In some cases, a station will have a caption that might
describe a nearby place of interest. This is \code{NA} if there isn't a caption
for the station name.}
\item{lines}{All Metro lines associated with the station. This is a
\code{character}-based, comma-separated series of line names.}
\item{connect_rer}{Station connections with the RER. The RER system has
five lines (A, B, C, D, and E) with 257 stations and several interchanges
with the Metro.}
\item{connect_tram}{Connections with tramway lines. This system has twelve
lines in operation (T1, T2, T3a, T3b, T4, T5, T6, T7, T8, T9, T11, and T13)
with 235 stations.}
\item{connect_transilien}{Connections with Transilien lines. This system has
eight lines in operation (H, J, K, L, N, P, R, and U).}
\item{connect_other}{Other connections with transportation infrastructure
such as regional, intercity, night, and high-speed trains (typically at
railway stations).}
\item{latitude, longitude}{The location of the station, given as
latitude and longitude values in decimal degrees.}
\item{location}{The arrondissement of Paris or municipality in which the
station resides. For some stations located at borders, the grouping of
locations will be presented as a comma-separated series}
\item{passengers}{The total number of Metro station entries during 2021. Some
of the newest stations in the Metro system do not have this data, thus they
show \code{NA} values.}
}
}
\usage{
metro
}
\description{
A dataset with information on all 314 Paris Metro stations as of June 2024.
Each record represents a station, describing which Metro lines are serviced
by the station, which other connections are available, and annual passenger
volumes. Basic location information is provided for each station in terms
of where they reside on a municipal level, and, through latitude/longitude
coordinate values.

The system has 16 lines (numbered from 1 to 14, with two additional lines:
3bis and 7bis) and covers over 200 kilometers of track. The Metro runs on
standard gauge tracks (1,435 mm) and operates using a variety of rolling
stock, including rubber-tired trains and steel-wheeled trains (which are far
more common).

The Metro is operated by the RATP, which also operates other transit systems
in the region, including buses, trams, and the RER. The RER is an important
component of the region's transit infrastructure, and several RER stations
have connectivity with the Metro. This integration allows passengers to
transfer between those two systems seamlessly. The Metro also has connections
to the Transilien rail network, tramway stations, several major train
stations (e.g., Gare du Nord, Gare de l'Est, etc.), and many bus lines.
}
\section{Dataset ID and Badge}{

DATA-10

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_metro.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
