% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_spiciness1}
\alias{gsw_spiciness1}
\title{Seawater Spiciness at p=1000 dbar}
\usage{
gsw_spiciness1(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
spiciness [ kg/m^3 ]
}
\description{
Calculate seawater spiciness referenced to 1000 dbar.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
spiciness <- gsw_spiciness1(SA, CT)
stopifnot(all.equal(spiciness, c(6.311038322123224, 6.326411175472160, 4.667218659743284,
                                 1.351722468726905, 0.628494082166029, 0.224779784908478)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_spiciness1.html}
}
\seealso{
Other things related to spiciness: 
\code{\link{gsw_spiciness0}()},
\code{\link{gsw_spiciness2}()}
}
\concept{things related to spiciness}
