% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_frazil_ratios_adiabatic}
\alias{gsw_frazil_ratios_adiabatic}
\title{Ratios of SA, CT and p changes when Frazil Ice Forms}
\usage{
gsw_frazil_ratios_adiabatic(SA, p, w_Ih)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{w_Ih}{initial mass fraction (ice) / (water + ice)}
}
\value{
a list containing \code{dSA_dCT_frazil}, \code{dSA_dP_frazil} and \code{dCT_dP_frazil}.
}
\description{
Ratios of changes in \code{SA}, \code{CT} and \code{p} that occur
when frazil ice forms due to changes in pressure upon
the mixture of seawater and ice.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(  34.7118,   34.8915,   35.0256,   34.8472,   34.7366,   34.7324)
p <- c(        10,        50,       125,       250,       600,      1000)
w_Ih <- c(    0.9,      0.84,       0.4,      0.25,      0.05,      0.01)
r <- gsw_frazil_ratios_adiabatic(SA, p, w_Ih)
stopifnot(all.equal(r$dSA_dCT_frazil,
    c(3.035152370800401, 1.932548405396193, 0.613212115809003,
     0.516103092738565, 0.436656742034200, 0.425827266533876)))
stopifnot(all.equal(r$dSA_dP_frazil/1e-6,
    c(-0.197406834470366, -0.133213926580032, -0.045580136143659,
     -0.038806356507548, -0.033541272953744, -0.033350141194082)))
stopifnot(all.equal(r$dCT_dP_frazil/1e-7,
    c(-0.650401727338347, -0.689317412221414, -0.743301297684333,
     -0.751910946738026, -0.768138213038669, -0.783184728059898)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_frazil_ratios_adiabatic.html}
}
