% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_first_derivatives}
\alias{gsw_pt_first_derivatives}
\title{First Derivatives of Potential Temperature}
\usage{
gsw_pt_first_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
A list containing \code{pt_SA} [ K/(g/kg) ], the derivative of
potential temperature with respect to Absolute Salinity,
and \code{pt_CT} [ unitless ], the derivative of potential temperature
with respect to Conservative Temperature.
}
\description{
First Derivatives of Potential Temperature
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
r <- gsw_pt_first_derivatives(SA, CT)
stopifnot(all.equal(r$pt_SA, c(0.041863223165431, 0.041452303483011, 0.034682095247246,
                               0.018711079068408, 0.014079958329844, 0.010577326129948)))
stopifnot(all.equal(r$pt_CT, c(0.997192967140242, 0.997451686508335, 0.998357568277750,
                               0.999996224076267, 1.000283719083268, 1.000525947028218)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_first_derivatives.html}
}
