% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_rho_alpha_beta}
\alias{gsw_rho_alpha_beta}
\title{In-situ density, thermal expansion coefficient and haline contraction coefficient (75-term equation)}
\usage{
gsw_rho_alpha_beta(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing in-situ density \code{rho} [ kg/m^3 ], thermal expansion
coefficient \code{alpha} [ 1/degC ], and haline contraction coefficient
\code{beta} [ kg/g ].
}
\description{
Calculate the in-situ density, the expansion coefficient (with respect to Conservative Temperature) and
the haline contraction coefficient (with respect to Absolute Salinity), using the
75-term equation.
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <-  c(     10,      50,     125,     250,     600,    1000)
r <- gsw_rho_alpha_beta(SA, CT, p)
expect_equal(r$rho/1000, c(1.021839935738108, 1.022262457966867, 1.024427195413316,
                         1.027790152759127, 1.029837779000189, 1.032002453224572))
expect_equal(r$alpha*1000, c(0.324638934509245, 0.322655537959731, 0.281145723210171,
                           0.173199716344780, 0.146289673594824, 0.129414845334599))
expect_equal(r$beta*1000, c(0.717483987596135, 0.717647512290095, 0.726211643644768,
                          0.750500751749777, 0.755052064788492, 0.757050813384370))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_rho_alpha_beta.html}
}
\seealso{
Other things related to density: \code{\link{gsw_CT_from_rho}},
  \code{\link{gsw_CT_maxdensity}},
  \code{\link{gsw_SA_from_rho}},
  \code{\link{gsw_alpha_on_beta}},
  \code{\link{gsw_alpha_wrt_t_exact}},
  \code{\link{gsw_alpha_wrt_t_ice}},
  \code{\link{gsw_alpha}},
  \code{\link{gsw_beta_const_t_exact}},
  \code{\link{gsw_beta}},
  \code{\link{gsw_pot_rho_t_exact}},
  \code{\link{gsw_rho_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_rho_first_derivatives}},
  \code{\link{gsw_rho_ice}}, \code{\link{gsw_rho_t_exact}},
  \code{\link{gsw_rho}}, \code{\link{gsw_sigma0}},
  \code{\link{gsw_sigma1}}, \code{\link{gsw_sigma2}},
  \code{\link{gsw_sigma3}}, \code{\link{gsw_sigma4}},
  \code{\link{gsw_specvol_alpha_beta}},
  \code{\link{gsw_specvol_anom_standard}},
  \code{\link{gsw_specvol_ice}},
  \code{\link{gsw_specvol_t_exact}},
  \code{\link{gsw_specvol}}
}
