% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_grav}
\alias{gsw_grav}
\title{Gravitational Acceleration}
\usage{
gsw_grav(latitude, p = 0)
}
\arguments{
\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
gravitational acceleration [ m/s^2 ]
}
\description{
Gravitational Acceleration
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
lat <- c(-90, -60, -30, 0)
grav <- gsw_grav(lat)
expect_equal(grav, c(9.832186205884799, 9.819178859991149,
                     9.793249257048750, 9.780327000000000))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_grav.html}
}
