% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_chem_potential_water_ice}
\alias{gsw_chem_potential_water_ice}
\title{Chemical Potential of Ice}
\usage{
gsw_chem_potential_water_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
chemical potential [ J/kg ]
}
\description{
Chemical Potential of Ice
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,      600,      1000)
pot <- gsw_chem_potential_water_ice(t, p)
expect_equal(pot/1e4, c(-1.340648365149857, -1.644921413491445, -1.480991678890353,
                      -1.272436055728805, -0.711509477199393, 0.045575390357792))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_chem_potential_water_ice.html}
}
\seealso{
Other things related to chemical potential: \code{\link{gsw_chem_potential_water_t_exact}}
}
